package org.iri_research.renkan.controller;

import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

public class Utils {

    public static String buildBaseUrl(HttpServletRequest request) {
        StringBuffer baseUrl = request.getRequestURL();
        boolean firstParam = true;
        Enumeration<?> namesEnum = request.getParameterNames();
        while (namesEnum.hasMoreElements()) {
            String paramName = (String) namesEnum.nextElement();

            if ("p.page".equals(paramName)) {
                continue;
            }
            for (String val : request.getParameterValues(paramName)) {
                if (firstParam) {
                    baseUrl.append('?');
                    firstParam = false;
                } else {
                    baseUrl.append('&');
                }
                baseUrl.append(paramName).append('=').append(val);
            }
        }
        return baseUrl.toString();
    }
}
