package org.iri_research.renkan.models;

import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import com.fasterxml.jackson.annotation.JsonProperty;


@Document(collection="edges")
public class Edge extends AbstractRenkanModel<String> {

	@DBRef
	private Node from;
	
	@DBRef
	private Node to;
	
	@Field("project_id")
	@JsonProperty("project_id")
	private String projectId;
	
	@Field("created_by")
	@JsonProperty("created_by")
	private String createdBy;
	

	public Edge(String id, String title, String description, String uri, String color, Node from, Node to, String createdBy, String projectId) {
		super(id,title, description, uri, color);
		this.from = from;
		this.to = to;
		this.createdBy = createdBy;
		this.projectId = projectId;
	}


	@JsonProperty("project_id")
	public String getProjectId() {
		return projectId;
	}


	public String getCreatedBy() {
		return createdBy;
	}
	
	public String getFrom() {
		if(this.from != null) {
			return this.from.id;
		}
		else {
			return null;
		}
	}

	public String getTo() {
		if(this.to != null) {
			return this.to.id;
		}
		else {
			return null;
		}
	}

}
