package org.iri_research.renkan.rest;


import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.ws.rs.Path;

import org.iri_research.renkan.models.Space;
import org.iri_research.renkan.repositories.IRenkanRepository;
import org.iri_research.renkan.repositories.SpacesRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.sun.jersey.spi.resource.Singleton;

@Singleton
@Path("spaces")
@Component
public class SpacesResource extends RenkanResource<Space, String> {
	
	@SuppressWarnings("unused")
	private Logger logger = LoggerFactory.getLogger(SpacesResource.class);
	
	private String[] spaceObjectListFieldList = {"created_by","bin_config","image"};
	
	@Autowired
	private SpacesRepository spacesRepository;
		
	@Override
	protected IRenkanRepository<Space, String> getRepository() {		
		return spacesRepository;
	}


	@Override
	protected String getNewId() {
		return UUID.randomUUID().toString();
	}


	@Override
	protected void prepareObject(Space obj) {
		if(obj.getCreated() == null) {
			obj.setCreated(new Date());
		}
	}


	@Override
	protected List<String> getObjectListFieldList() {
		ArrayList<String> fieldList = new ArrayList<>(this.baseObjectListFieldList.length + this.spaceObjectListFieldList.length);
		fieldList.addAll(Arrays.asList(this.baseObjectListFieldList));
		fieldList.addAll(Arrays.asList(this.spaceObjectListFieldList));
		return fieldList;
	}


}
