package org.iri_research.renkan.models;

import java.util.Date;

import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import com.fasterxml.jackson.annotation.JsonProperty;

@Document(collection="spaces")
public class Space extends AbstractRenkanModel<String> {
	

	public Space(String id, String title, String description, String binConfig, String uri, String color, String createdBy, String image, Date created) {
		super(id, title, description, uri, color);
		
		this.binConfig = binConfig;
		this.createdBy = createdBy;
		this.image = image;
		this.created = created;
		if(this.created == null) {
			this.created = new Date();
		}
	}
	
	@SuppressWarnings("unused")
	private Space() {		
	}

	@Field("bin_config")
	@JsonProperty("bin_config")
	private String binConfig;
	
	@Field("created_by")
	@JsonProperty("created_by")
	private String createdBy = null;	
	private String image;
	private Date created;
	
	public String getImage() {
		return image;
	}

	@JsonProperty("created_by")
	public String getCreatedBy() {
		return createdBy;
	}
	
	public Date getCreated() {
		return created;
	}
	
	public void setCreated(Date date) {
		this.created = date;
		
	}

	@JsonProperty("bin_config")
	public String getBinConfig() {
		return binConfig;
	}

	@JsonProperty("bin_config")
	public void setBinConfig(String bin_config) {
		this.binConfig = bin_config;
	}
	
}