package org.iri_research.renkan.models;

import java.util.UUID;

import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.mapping.Field;

import com.fasterxml.jackson.annotation.JsonProperty;

public class View extends AbstractRenkanModel<String> {

    private DateTime created;
    private DateTime updated;
    
    @Field("zoom_level")
    @JsonProperty("zoom_level")
    private double zoomLevel;
    
    private Point offset;

    @Field("created_by")
    @JsonProperty("created_by")
    private String createdBy;
    
    @SuppressWarnings("unused")
    private View() {
    }

    public View(String view_id, String title, String description, String uri,
            String color, String creatorId, double zoomLevel, Point offset) {
        super(view_id, title, description, uri, color);
        this.createdBy = creatorId;
        this.zoomLevel = zoomLevel;
        this.offset = offset;
        this.created = new DateTime();
        this.updated = new DateTime();
    }
    
    @Autowired(required = true)
    public View(String view_id, String title, String description, String uri,
            String color, String creatorId, double zoomLevel, Point offset, DateTime created) {
        this(view_id, title, description, uri, color, creatorId, zoomLevel, offset);
        if(created != null) {
            this.created= created;
        }
    }

    @Override
    protected String getRawKeyPart() {
        return this.id+Long.toString(this.getCreated().getMillis());
    }

    @Override
    protected String getDefaultId() {
        return UUID.randomUUID().toString();
    }

    public DateTime getCreated() {
        return created;
    }

    public void setCreated(DateTime created) {
        this.created = created;
    }

    public DateTime getUpdated() {
        return updated;
    }

    public void setUpdated(DateTime updated) {
        this.updated = updated;
    }

    public String getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public double getZoomLevel() {
        return zoomLevel;
    }

    public void setZoomLevel(double zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public Point getOffset() {
        return offset;
    }

    public void setOffset(Point offset) {
        this.offset = offset;
    }
    

}
