package org.iri_research.renkan.models;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

import com.fasterxml.jackson.annotation.JsonFormat;

@Document(collection = "projectRevisions")
public class ProjectRevision extends AbstractRenkanModel<ObjectId> {

    @SuppressWarnings("unused")
    private static Logger logger = LoggerFactory
            .getLogger(ProjectRevision.class);

    private int revision;

    @DBRef
    private Project project;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone = "GMT")
    private Date created;

    // Nodes
    private List<Node> nodes = new ArrayList<Node>();

    // Edgess
    private List<Edge> edges = new ArrayList<Edge>();

    @SuppressWarnings("unused")
    private ProjectRevision() {
        super();
    }

    public ProjectRevision(String title, String description, String uri,
            Project project, int revision, Date created) {
        this(null, title, description, uri, project, revision, created);
    }

    public ProjectRevision(ObjectId id, String title, String description,
            String uri, Project project, int revision, Date created) {
        super(id, title, description, uri, null);
        this.project = project;
        this.revision = revision;
        if (created == null) {
            this.created = new Date(System.currentTimeMillis());
        }
    }

    public int getRevision() {
        return revision;
    }

    public Project getProject() {
        return project;
    }

    public List<Node> getNodes() {
        return nodes;
    }

    public List<Edge> getEgdes() {
        return edges;
    }

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ", timezone = "GMT")
    public Date getCreated() {
        return created;
    }

    @Override
    protected String getRawKeyPart() {
        return Long.toString(this.getCreated().getTime());
    }

}
