
//Load modules and use them
if( typeof require.config === "function" ) {
    require.config({
        paths: {
            'jquery':'../lib/jquery/jquery',
            'underscore':'../lib/underscore/underscore',
            'filesaver' :'../lib/FileSaver/FileSaver',
            'requtils':'require-utils'
        }
    });
}

require(['renderer/baserepresentation',
         'renderer/basebutton',
         'renderer/noderepr',
         'renderer/edge',
         'renderer/tempedge',
         'renderer/baseeditor',
         'renderer/nodeeditor',
         'renderer/edgeeditor',
         'renderer/nodebutton',
         'renderer/nodeeditbutton',
         'renderer/noderemovebutton',
         'renderer/noderevertbutton',
         'renderer/nodelinkbutton',
         'renderer/nodeenlargebutton',
         'renderer/nodeshrinkbutton',
         'renderer/edgeeditbutton',
         'renderer/edgeremovebutton',
         'renderer/edgerevertbutton',
         'renderer/miniframe',
         'renderer/scene'
         ], function(BaseRepresentation, BaseButton, NodeRepr, Edge, TempEdge, BaseEditor, NodeEditor, EdgeEditor, NodeButton, NodeEditButton, NodeRemoveButton, NodeRevertButton, NodeLinkButton, NodeEnlargeButton, NodeShrinkButton, EdgeEditButton, EdgeRemoveButton, EdgeRevertButton, MiniFrame, Scene){

    'use strict';

    var Rkns = window.Rkns;

    if(typeof Rkns.Renderer === "undefined"){
        Rkns.Renderer = {};
    }
    var Renderer = Rkns.Renderer;

    Renderer._BaseRepresentation = BaseRepresentation;
    Renderer._BaseButton = BaseButton;
    Renderer.Node = NodeRepr;
    Renderer.Edge = Edge;
    Renderer.TempEdge = TempEdge;
    Renderer._BaseEditor = BaseEditor;
    Renderer.NodeEditor = NodeEditor;
    Renderer.EdgeEditor = EdgeEditor;
    Renderer._NodeButton = NodeButton;
    Renderer.NodeEditButton = NodeEditButton;
    Renderer.NodeRemoveButton = NodeRemoveButton;
    Renderer.NodeRevertButton = NodeRevertButton;
    Renderer.NodeLinkButton = NodeLinkButton;
    Renderer.NodeEnlargeButton = NodeEnlargeButton;
    Renderer.NodeShrinkButton = NodeShrinkButton;
    Renderer.EdgeEditButton = EdgeEditButton;
    Renderer.EdgeRemoveButton = EdgeRemoveButton;
    Renderer.EdgeRevertButton = EdgeRevertButton;
    Renderer.MiniFrame = MiniFrame;
    Renderer.Scene = Scene;

    startRenkan();
});
