/*
 * Decompiled with CFR 0.152.
 */
package org.coweb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;

public class CowebExtension
implements BayeuxServer.Extension {
    private PrintWriter outgoing = null;
    private PrintWriter incoming = null;

    public CowebExtension() {
    }

    public CowebExtension(String incomingFileName, String outgoingFileName) {
        try {
            if (incomingFileName != null) {
                this.incoming = new PrintWriter(new File(incomingFileName));
            }
            if (incomingFileName != null && outgoingFileName != null && incomingFileName.equals(outgoingFileName)) {
                this.outgoing = this.incoming;
            } else if (outgoingFileName != null) {
                this.outgoing = new PrintWriter(new File(outgoingFileName));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void setOutgoing(String fileName) throws FileNotFoundException {
        this.outgoing = new PrintWriter(new File(fileName));
    }

    public void setIncoming(String fileName) throws FileNotFoundException {
        this.incoming = new PrintWriter(new File(fileName));
    }

    private void writeMessage(String msg, PrintWriter w) {
        try {
            w.println(msg);
            w.println();
            w.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean rcv(ServerSession client, ServerMessage.Mutable msg) {
        if (client != null) {
            this.incoming.println("received message from " + client.getId());
        }
        this.writeMessage(msg.toString(), this.incoming);
        return true;
    }

    public boolean rcvMeta(ServerSession client, ServerMessage.Mutable msg) {
        return true;
    }

    public boolean sendMeta(ServerSession arg0, ServerMessage.Mutable msg) {
        return true;
    }

    public boolean send(ServerSession from, ServerSession to, ServerMessage.Mutable msg) {
        if (to != null) {
            this.outgoing.println("sending message to " + to.getId());
        }
        this.writeMessage(msg.toString(), this.outgoing);
        return true;
    }
}

