# -*- coding: utf-8 -*-
'''
Created on Mar 13, 2012

@author: ymh and tc
'''
from django.core.cache import cache
from django.core.exceptions import ValidationError
from django.http.response import Http404
from django.shortcuts import get_object_or_404
from django.utils.encoding import smart_str
from renkanmanager.models import Renkan
import math
import hashlib
import re
import uuid

import logging
logger = logging.getLogger(__name__)


def fix_cache_key(key):
    cache_key = re.sub(r'\s+', '-', key)
    cache_key = smart_str(cache_key)
    if len(cache_key) > (250-(2+len(cache.key_prefix)+len(str(cache.version)))-33):
        cache_key = cache_key[:(250-(2+len(cache.key_prefix)+len(str(cache.version)))-33)] + '-' + hashlib.md5(cache_key).hexdigest()
    return cache_key



class NodePlacer():
    
    cat_nb_nodes = {}
    
    def init(self, cat_nb_nodes_initial):
        raise NotImplementedError( "Should have implemented init" )
    
    def get_place(self, category):
        if not category or category not in self.cat_nb_nodes:
            raise Http404
        return self.cat_nb_nodes[category].pop(0)



class LineNodePlacer(NodePlacer): #vertical lines
    
    max_length = 0
    
    def init(self, cat_nb_nodes_initial):
        for c in cat_nb_nodes_initial:
            nb = cat_nb_nodes_initial[c]
            if isinstance(cat_nb_nodes_initial[c], tuple):
                _, nb = nb
            self.max_length = nb if nb > self.max_length else self.max_length
        for i_cat,c in enumerate(cat_nb_nodes_initial):
            self.cat_nb_nodes[c] = []
            order = i_cat
            nb = cat_nb_nodes_initial[c]
            if isinstance(cat_nb_nodes_initial[c], tuple):
                order, nb = nb
            offset = float(self.max_length - nb) / 2
            for i in xrange(nb):
                if c=="northwest":
                    self.cat_nb_nodes[c].append({ "x": order*500, "y": offset })
                else:
                    self.cat_nb_nodes[c].append({ "x": order*500, "y": 100*(i+offset) })


class HorLineNodePlacer(NodePlacer): #horizontal lines
    
    max_length = 0
    
    def init(self, cat_nb_nodes_initial):
        for c in cat_nb_nodes_initial:
            nb = cat_nb_nodes_initial[c]
            if isinstance(cat_nb_nodes_initial[c], tuple):
                _, nb = nb
            self.max_length = nb if nb > self.max_length else self.max_length
        for i_cat,c in enumerate(cat_nb_nodes_initial):
            self.cat_nb_nodes[c] = []
            order = i_cat
            nb = cat_nb_nodes_initial[c]
            if isinstance(cat_nb_nodes_initial[c], tuple):
                order, nb = nb
            offset = float(self.max_length - nb) / 2
            for i in xrange(nb):
                if c=="northwest":
                    self.cat_nb_nodes[c].append({ "x": offset, "y": order*500 })
                else:
                    if (i%2) == 0:
                        self.cat_nb_nodes[c].append({ "x": 100*(i+offset), "y": order*500 })
                    else:
                        self.cat_nb_nodes[c].append({ "x": 100*(i+offset), "y": order*450 })

class CircleNodePlacer(NodePlacer):
    
    def init(self, cat_nb_nodes_initial):
        for i_cat,c in enumerate(cat_nb_nodes_initial):
            self.cat_nb_nodes[c] = []
            order = i_cat
            nb = cat_nb_nodes_initial[c]
            if isinstance(cat_nb_nodes_initial[c], tuple):
                order, nb = nb
            order -= 1
            for i in xrange(nb):
                radius = (order*500) if order>0 else 100
                angle = 2 * math.pi * i / nb
                if c=="northwest":
                    self.cat_nb_nodes[c].append({ "x": -radius, "y": -radius })
                else:
                    self.cat_nb_nodes[c].append({ "x": radius*math.cos(angle), "y": radius*math.sin(angle) })



def renkan_copier(user, old_rk_id):
    old_rk = get_object_or_404(Renkan, rk_id=old_rk_id)
    rk = Renkan()
    rk.rk_id = unicode(uuid.uuid1())
    rk.owner = user
    rk.content = old_rk.content
    #TODO : update title and uuid in the content's json data
    rk.title = old_rk.title + " (copy)"
    rk.save()
    return rk



def renkan_deleter(user, rk_id):
    rk = get_object_or_404(Renkan, rk_id=rk_id)
    if rk.owner==user:
        rk.delete()
    else:
        raise ValidationError("You are not allowed to remove this renkan")



