Rkns.defaults = {
    
    language: (navigator.language || navigator.userLanguage || "en"),
        /* GUI Language */
    container: "renkan",
        /* GUI Container DOM element ID */
    search: [],
        /* List of Search Engines */
    bins: [],
           /* List of Bins */
    static_url: "",
        /* URL for static resources */
    show_bins: true,
        /* Show bins in left column */
    properties: [],
        /* Semantic properties for edges */
    show_editor: true,
        /* Show the graph editor... Setting this to "false" only shows the bins part ! */
    read_only: false,
        /* Allows editing of renkan without changing the rest of the GUI. Can be switched on/off on the fly to block/enable editing */
    editor_mode: true,
        /* Switch for Publish/Edit GUI. If editor_mode is false, read_only will be true.  */
    snapshot_mode: false,
        /* In snapshot mode, clicking on the floppy will save a snapshot. Otherwise, it will show the connection status */
    show_top_bar: true,
        /* Show the top bar, (title, buttons, users) */
    default_user_color: "#303030",
    size_bug_fix: true,
        /* Resize the canvas after load (fixes a bug on iPad and FF Mac) */
    force_resize: false,
    allow_double_click: true,
        /* Allows Double Click to create a node on an empty background */
    element_delete_delay: 0,
        /* Delay between clicking on the bin on an element and really deleting it
           Set to 0 for delete confirm */
    autoscale_padding: 50,
    
    /* TOP BAR BUTTONS */
    show_user_list: true,
    show_save_button: true,
    show_open_button: false,
    show_addnode_button: true,
    show_addedge_button: true,
    show_bookmarklet: true,
    show_fullscreen_button: true,
    home_button_url: false,
    home_button_title: "Home",
    
    /* MINI-MAP OPTIONS */
    
    show_minimap: true,
        /* Show a small map at the bottom right */
    minimap_width: 160,
    minimap_height: 120,
    minimap_padding: 20,
    minimap_background_color: "#ffffff",
    minimap_border_color: "#cccccc",
    minimap_highlight_color: "#ffff00",
    minimap_highlight_weight: 5,
    
    /* EDGE/NODE COMMON OPTIONS */
       
    buttons_background: "#202020",
    buttons_label_color: "#c000c0",
    buttons_label_font_size: 9,
    
    /* NODE DISPLAY OPTIONS */
    
    show_node_circles: true,
        /* Show circles for nodes */
    clip_node_images: true,
        /* Constraint node images to circles */
    node_images_fill_mode: false,
        /* Set to false for "letterboxing" (height/width of node adapted to show full image)
           Set to true for "crop" (adapted to fill circle) */
    node_size_base: 25,
    node_stroke_width: 2,
    selected_node_stroke_width: 4,
    node_fill_color: "#ffffff",
    highlighted_node_fill_color: "#ffff00",
    node_label_distance: 5,
        /* Vertical distance between node and label */
    node_label_max_length: 60,
        /* Maximum displayed text length */
    label_untitled_nodes: "(untitled)",
        /* Label to display on untitled nodes */
    
    /* EDGE DISPLAY OPTIONS */
    
    edge_stroke_width: 2,
    selected_edge_stroke_width: 4,
    edge_label_distance: 0,
    edge_label_max_length: 20,
    edge_arrow_length: 18,
    edge_arrow_width: 12,
    edge_gap_in_bundles: 12,
    label_untitled_edges: "",
    
    /* CONTEXTUAL DISPLAY (TOOLTIP OR EDITOR) OPTIONS */
   
    tooltip_width: 275,
    tooltip_padding: 10,
    tooltip_margin: 15,
    tooltip_arrow_length : 20,
    tooltip_arrow_width : 40,
    tooltip_top_color: "#f0f0f0",
    tooltip_bottom_color: "#d0d0d0",
    tooltip_border_color: "#808080",
    tooltip_border_width: 1,
    
    /* NODE EDITOR OPTIONS */
    
    show_node_editor_uri: true,
    show_node_editor_description: true,
    show_node_editor_size: true,
    show_node_editor_color: true,
    show_node_editor_image: true,
    show_node_editor_creator: true,
    uploaded_image_max_kb: 500,
    
    /* NODE TOOLTIP OPTIONS */
    
    show_node_tooltip_uri: true,
    show_node_tooltip_description: true,
    show_node_tooltip_color: true,
    show_node_tooltip_image: true,
    show_node_tooltip_creator: true,
    
    /* EDGE EDITOR OPTIONS */
    
    show_edge_editor_uri: true,
    show_edge_editor_color: true,
    show_edge_editor_direction: true,
    show_edge_editor_nodes: true,
    show_edge_editor_creator: true,
    
    /* EDGE TOOLTIP OPTIONS */
    
    show_edge_tooltip_uri: true,
    show_edge_tooltip_color: true,
    show_edge_tooltip_nodes: true,
    show_edge_tooltip_creator: true
    
    /* */
    
};
