Rkns.Renderers.Paper = Rkns.Utils.inherit(Rkns.Renderers._Base);

Rkns.Renderers.Paper__Controllers = {}

Rkns.Renderers.Paper__Controllers._Base = function(_renderer, _element) {
    if (typeof _renderer !== "undefined") {
        this._renderer = _renderer;
        this._element = _element;
        this._element._renderer_controller = this;
    }
}

Rkns.Renderers.Paper__Controllers.Node = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);

Rkns.Renderers.Paper__Controllers.Node.prototype._init = function() {
    this.node_circle = new paper.Path.Circle([0, 0], 20);
    this.redraw();
}

Rkns.Renderers.Paper__Controllers.Node.prototype.redraw = function() {
    var _centerPoint = paper.view.center.add([this._element.position.x, this._element.position.y]);
    this.node_circle.position = _centerPoint;
    this.node_circle.strokeColor = this._element.created_by.color;
}

Rkns.Renderers.Paper__Controllers.Edge = Rkns.Utils.inherit(Rkns.Renderers._Base);

Rkns.Renderers.Paper.prototype._init = function() {
    paper.setup(document.getElementById(this._project._opts.canvas_id));
}

Rkns.Renderers.Paper.prototype.draw = function() {
    var _this = this;
    this.nodes = this._project.nodes.map(function(_node) {
        return new Rkns.Renderers.Paper__Controllers.Node(_this, _node);
    });
    paper.view.draw();
    paper.view.onResize = function() {
        _this.redraw();
    }
}

Rkns.Renderers.Paper.prototype.redraw = function() {
    Rkns._(this.nodes).each(function(_node) {
        _node.redraw();
    })
}
