package org.iri_research.renkan.repositories;

import java.util.List;

import org.iri_research.renkan.models.Space;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.Query;

public interface SpacesRepository extends IRenkanRepository<Space, String> {

    @Query("{ 'title' : { '$regex':?0, '$options': 'i'}, }")
    List<Space> findByTitleRegex(String title);

    @Query("{ 'title' : { '$regex':?0, '$options': 'i'}, }")
    Page<Space> findByTitleRegex(String title, Pageable p);

}
