from rest_framework import permissions


class CanCreateRenkan(permissions.BasePermission):
    
    def has_permission(self, request, view):
        if request.method in permissions.SAFE_METHODS:
            return True
        
        if (request.method == 'POST') and not request.user.has_perm('add_renkan'):
            return False
        
        return True


class CanEditRenkan(permissions.BasePermission):
    
    def has_object_permission(self, request, view, obj):
        if not request.user.has_perm('view_renkan', obj):
            return False
        if request.method in permissions.SAFE_METHODS:
            return True
        
        if (request.method == 'PUT') and not request.user.has_perm('change_renkan', obj):
            return False
        
        return True


class CanDeleteRenkan(permissions.BasePermission):
    
    def has_object_permission(self, request, view, obj):
        if not request.user.has_perm('view_renkan', obj):
            return False
        if request.method in permissions.SAFE_METHODS:
            return True
        
        if (request.method == 'DELETE') and not request.user.has_perm('delete_renkan', obj):
            return False
        
        return True


class CanCreateWorkspace(permissions.BasePermission):
    
    def has_permission(self, request, view):
        if request.method in permissions.SAFE_METHODS:
            return True
        if (request.method == 'POST') and not request.user.has_perm('add_workspace'):
            return False
        
        return True


class CanEditWorkspace(permissions.BasePermission):
    
    def has_object_permission(self, request, view, obj):
        if not request.user.has_perm('view_workspace', obj):
            return False
        if request.method in permissions.SAFE_METHODS:
            return True
        
        if (request.method == 'PUT') and not request.user.has_perm('change_workspace', obj):
            return False
        
        return True


class CanDeleteWorkspace(permissions.BasePermission):
    
    def has_object_permission(self, request, view, obj):
        if not request.user.has_perm('view_workspace', obj):
            return False
        if request.method in permissions.SAFE_METHODS:
            return True
        
        if (request.method == 'DELETE') and not request.user.has_perm('delete_workspace', obj):
            return False
        
        return True


class CanDeleteRevision(permissions.BasePermission):
    
    def has_object_permission(self, request, view, obj):
        if not request.user.has_perm('view_revision', obj):
            return False
        if request.method in permissions.SAFE_METHODS:
            return True
        
        if (request.method == 'DELETE') and not request.user.has_perm('delete_revision', obj):
            return False
        
        return True