package org.iri_research.renkan.models;

import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;


@Document(collection="relations")
public class Relation extends AbstractRenkanModel<String> {

	@DBRef
	private Node srcNode;
	
	@DBRef
	private Node tgtNode;

	public Relation(String id, String title, String description, String uri, Node srcNode, Node tgtNode) {
		super(id,title, description, uri);
		this.srcNode = srcNode;
		this.tgtNode = tgtNode;				
	}

}
