define([
    "dojo",
    "coweb/main",
], function(dojo, coweb) {

    var CoRenkanApp = function() {
    };

    var proto = CoRenkanApp.prototype;

    proto.init = function() {
    	console.log("ready callback");
    	
    	//this.initCollab();
    	
    	var sess = coweb.initSession();
    	sess.onStatusChange = function(status) {
    	    console.log(status);
    	};
    	sess.prepare();
    	this.project = null;
                
    };
    
    proto.initCollab = function(id) {    	
    	this.collab = coweb.initCollab({id : id});
    	this.collab.subscribeSync("project", this, "onRemoteProjectChange");    	
    };
    
    function prepareValues(obj,c) {
		values = {};
		for(var fieldname in c.changes) {
			if(c.changes[fieldname]) {
				values[fieldname] = obj.get(fieldname);
			}    			
		}
		return values;
    }
    
    proto.setProject = function(project) {
    	
    	var projectFields = ["title", "description", "uri"];
    	var that = this;
    	for(var fieldIndex in projectFields) {
    		(function(fi){
	    		var field = projectFields[fi];
	        	project.bind("change:"+field, function(obj, c) {
	        		console.log(c);
	        		values = {
	        		    id: obj.id,
	        		    type: "project"
	        		};
	        		values[field] = c;
	        		that.collab.sendSync("project", values);
	        	});
    		})(fieldIndex);
    	}
    	this.project = project;
    	this.initCollab(project.id);
    };
    
    
    /**
     * Called when a remote data store changes in some manner. Dispatches to
     * local methods for insert, update, delete handling.
     * TODO: manage project list change on server
     * @param args Cooperative web event
     */
    proto.onRemoteProjectChange = function(args) {    	
    	console.log(args);
    	if (args.type === "update") {
            this.onRemoteProjectUpdate(args.value, args.position);
    	}
        /*if (args.type === "insert") {
            this.onRemoteInsert(value, args.position);
        } else if (args.type === "update") {
            this.onRemoteUpdate(value, args.position);
        } else if (args.type === "delete") {
            this.onRemoteDelete(args.position);
        }*/
    };
    
    /**
     * Called when a project attribute changes value in a remote data store.
     * Updates the attribute value of the item with the same id in the local
     * data store.
     *
     * @param value Item data sent by remote data store
     * @param position Which item to update.
     */
    proto.onRemoteProjectUpdate = function(values, position) {
    	var project_id = values['id'];
    	if(typeof(project_id) === "undefined") {
    		return;
		}
    	
    	if(this.project != null && project_id == this.project.id) {
    		for(var fieldname in values) {
    			if(fieldname != "id" && fieldname != "type") {
    				this.project.set(fieldname, values[fieldname]);
    			}
    		}
    	}
    	
    };
        
    var app = new CoRenkanApp();
    dojo.ready(function() {
        app.init();
    });
    
    
    return {
    	app: app
    };
});