package org.iri_research.renkan.coweb.event;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public abstract class AbstractSyncEventManager implements ISyncEventManager {

	private final Logger logger = LoggerFactory.getLogger(AbstractSyncEventManager.class);
	
	@Override
	public boolean dispatchEvent(Map<String, Object> data) {

		String eventType = (String) data.get("type");
		
		if("null".equalsIgnoreCase(eventType)) {
			return this.nullOperation(data);
		}
		else if ("update".equalsIgnoreCase(eventType)) {
			return this.update(data);
		}
		else if ("insert".equalsIgnoreCase(eventType)) {
			return this.insert(data);
		}
		else if("delete".equalsIgnoreCase(eventType)) {
			return this.delete(data);
		}
		
		logger.warn(String.format("dispatchEvent : eventType unknown %s", eventType));
		return false;
	}

	@Override
	public abstract boolean update(Map<String, Object> data);

	@Override
	public abstract boolean insert(Map<String, Object> data);

	@Override
	public abstract boolean delete(Map<String, Object> data);

	@Override
	public abstract boolean nullOperation(Map<String, Object> data);

}
