package org.iri_research.renkan.test.repositories;


import java.sql.Array;
import java.util.ArrayList;

import org.iri_research.renkan.models.Project;
import org.iri_research.renkan.repositories.ProjectsRepository;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;


@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration("repositories-context.xml")
public class ProjectsRepositoryTest {

	private Logger logger = LoggerFactory.getLogger(ProjectsRepositoryTest.class);
	
	@Autowired
	private ProjectsRepository projectRepository;
	
	private ArrayList<Project> testProjects = new ArrayList<Project>();
	
	public ProjectsRepositoryTest() {
	}
	
	@Before
	public void setup() {
		
		logger.debug("Setup");		
		ArrayList<Project> pl = new ArrayList<Project>();
		pl.add(new Project(null, "test1", "desc1", "http://localhost:8080/rest/projects/id1"));
		pl.add(new Project(null, "test2", "desc2", "http://localhost:8080/rest/projects/id2"));
		logger.debug("Setup : new Project ");
		for(Project p: projectRepository.save(pl)) {
			this.testProjects.add(p);
		}
	}
	
	@After
	public void teardown() {
		logger.debug("Teardown");
		projectRepository.deleteAll();
	}
	
	@Test
	public void testInitialRevCounter() {
		
		Project p = projectRepository.findOne(this.testProjects.get(0).getId());
		
		Assert.assertEquals("Initial rev counter should be 1", 1, p.getRevCounter());
	}
	
	@Test
	public void testIncrementRevCounter() {
		
		int revCounter = projectRepository.getRevCounter(this.testProjects.get(0).getId());
		Assert.assertEquals("After 1 call rev counter should be 1", 1, revCounter);
		revCounter = projectRepository.getRevCounter(this.testProjects.get(0).getId());
		Assert.assertEquals("After 2 calls rev counter should be 2", 2, revCounter);

		for(int i=0; i<10; i++) {
			revCounter = projectRepository.getRevCounter(this.testProjects.get(0).getId());
		}
		
		Assert.assertEquals("After 10 more calls rev counter should be 12", 12, revCounter);
		
		Project p = projectRepository.findOne(this.testProjects.get(0).getId());
		
		Assert.assertEquals("next rev counter should be 13", 13, p.getRevCounter());
		
		p = projectRepository.findOne(this.testProjects.get(1).getId());
		
		Assert.assertEquals("other project next rev counter should be 1", 1, p.getRevCounter());
		
	}
	
	
	@Test
	public void testIncrementNonExisting() {
		
		int revCounter = projectRepository.getRevCounter("aaaa");
		Assert.assertEquals("Rev counter non existing == -1", -1, revCounter);
		
	}
	
	@Test
	public void testIncrementNull() {
		
		int revCounter = projectRepository.getRevCounter(null);
		Assert.assertEquals("Rev counter null == -1", -1, revCounter);
		
	}

	@Test
	public void testIncrementEmpty() {
		
		int revCounter = projectRepository.getRevCounter("");
		Assert.assertEquals("Rev counter empty == -1", -1, revCounter);
		
	}
	
	
}
