/**
 * 
 */
package org.iri_research.renkan.coweb.event;

import java.util.Map;

import javax.inject.Inject;
import javax.inject.Named;

import org.coweb.CowebException;
import org.iri_research.renkan.repositories.ProjectsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;

/**
 * @author ymh
 *
 */
@Named
public class ProjectSyncEventManager extends AbstractSyncEventManager {

	private final Logger logger = LoggerFactory.getLogger(ProjectSyncEventManager.class);
	
	@Inject
	private ProjectsRepository projectsRepository;
	
	private DBCollection getCollection() {		
		return this.projectsRepository.getCollection();
	}
	
	/* Update a project
	 * @see org.iri_research.renkan.coweb.event.AbstractSyncEventManager#update(java.util.Map)
	 */
	@Override
	public boolean update(Map<String, Object> data) {
		
		this.logger.debug("ProjectSyncEventManager: update project");
		
		@SuppressWarnings("unchecked")
		Map<String, Object> values = (Map<String, Object>) data.get("value");
		String project_id = (String) values.get("id");
		
		// get project
		this.logger.debug(String.format("update project %s", project_id));
		try {
			this.logger.debug(String.format("rev Counter %d", projectsRepository.getRevCounter(project_id)));
		}
		catch(Exception e){
			this.logger.error("Bad rev counter",e);
		}
		
		DBCollection projectCollection = this.getCollection();
		DBObject project = projectCollection.findOne(project_id);
		
		if (null == project) {
			throw new CowebException("Project not found", String.format("Project %s not found", project_id));
		}
		
		boolean project_changed = false;
		// update project
		for (String fieldname : values.keySet()) {
			if(!"id".equalsIgnoreCase(fieldname) && project.containsField(fieldname))
			{
				Object new_value = values.get(fieldname);
				Object old_value = project.get(fieldname);
				if((new_value == null && old_value != null) || (new_value != null && !new_value.equals(old_value))) {
					project.put(fieldname, new_value);
					project_changed = true;
				}
			}
		}
		
		if(project_changed) {
			project.put("_id", project_id);
			WriteResult res = projectCollection.update(new BasicDBObject("_id", project_id), project, true, false);
			
			if(!res.getLastError().ok()) {
				throw new CowebException(String.format("Error when writing project %s", project_id), res.getLastError().getErrorMessage()); 
			}

		}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.iri_research.renkan.coweb.event.AbstractSyncEventManager#insert(java.util.Map)
	 */
	@Override
	public boolean insert(Map<String, Object> data) {
		// do nothing
		return false;
	}

	/* (non-Javadoc)
	 * @see org.iri_research.renkan.coweb.event.AbstractSyncEventManager#delete(java.util.Map)
	 */
	@Override
	public boolean delete(Map<String, Object> data) {
		// do nothing
		return false;
	}

	/* (non-Javadoc)
	 * @see org.iri_research.renkan.coweb.event.AbstractSyncEventManager#nullOperation(java.util.Map)
	 */
	@Override
	public boolean nullOperation(Map<String, Object> data) {
		// do nothing
		return false;
	}

}
