# -*- coding: utf-8 -*-
# Generated by Django 1.9.4 on 2016-06-16 14:57
from __future__ import unicode_literals

from django.db import migrations

def populate_foreign_keys(apps, schema_editor):
    Renkan = apps.get_model('renkanmanager', 'Renkan')
    Revision = apps.get_model('renkanmanager', 'Revision')
    Workspace = apps.get_model('renkanmanager', 'Workspace')

    for renkan in Renkan.objects.all():
        renkan.current_revision = Revision.objects.get(revision_guid=renkan.current_revision_guid)
        if renkan.source_revision_guid:
            renkan.source_revision = Revision.objects.get(revision_guid=renkan.source_revision_guid)
        if renkan.workspace_guid:
            renkan.workspace = Revision.objects.get(revision_guid=renkan.workspace_guid)
        renkan.save()

    for revision in Revision.objects.all():
        revision.parent_renkan = Renkan.objects.get(renkan_guid=revision.parent_renkan_guid)
        revision.save()


class Migration(migrations.Migration):

    dependencies = [
        ('renkanmanager', '0005_foreign_key_fields_initial'),
    ]

    operations = [
        migrations.RunPython(populate_foreign_keys)
    ]
