Rkns.Renderers.Paper = Rkns.Utils.inherit(Rkns.Renderers._Base);

Rkns.Renderers.Paper__Controllers = {}

Rkns.Renderers.Paper__Controllers._Base = function(_renderer, _element) {
    if (typeof _renderer !== "undefined") {
        this._renderer = _renderer;
        this._element = _element;
        this._element.__controller = this;
    }
}

Rkns.Renderers.Paper__Controllers.Node = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);

Rkns.Renderers.Paper__Controllers.Node.prototype._init = function() {
    this._renderer.node_layer.activate();
    this.type = "node";
    this.node_circle = new paper.Path.Circle([0, 0], 20);
    this.node_circle.fillColor = '#ffffff';
    this.node_circle.__controller = this;
    this.node_text = new paper.PointText([0,0]);
    this.node_text.characterStyle = {
        fontSize: 14,
        fillColor: 'black'
    };
    this.node_text.paragraphStyle.justification = 'center';
    this.node_text.__controller = this;
    this.redraw();
}

Rkns.Renderers.Paper__Controllers.Node.prototype.redraw = function() {
    this.node_model_coords = new paper.Point(this._element.position.x, this._element.position.y);
    this.node_paper_coords = this._renderer.toPaperCoords(this.node_model_coords);
    this.node_circle.position = this.node_paper_coords;
    this.node_text.content = this._element.title;
    this.node_text.position = this.node_paper_coords.add([0, 35]);
    this.node_circle.strokeColor = this._element.created_by.color;
}

Rkns.Renderers.Paper__Controllers.Node.prototype.paperShift = function(_delta) {
    this.node_paper_coords = this.node_paper_coords.add(_delta);
    this.node_model_coords = this._renderer.toModelCoords(this.node_paper_coords);
    this._element.position.x = this.node_model_coords.x;
    this._element.position.y = this.node_model_coords.y;
    this._renderer.redraw();
}

/* */

Rkns.Renderers.Paper__Controllers.Edge = Rkns.Utils.inherit(Rkns.Renderers.Paper__Controllers._Base);


Rkns.Renderers.Paper__Controllers.Edge.prototype._init = function() {
    this._renderer.edge_layer.activate();
    this.type = "edge";
    this.from_node_controller = this._element.from.__controller;
    this.to_node_controller = this._element.to.__controller;
    this.edge_line = new paper.Path();
    this.edge_line.add([0,0],[0,0]);
    this.edge_line.__controller = this;
    this.edge_text = new paper.PointText();
    this.edge_text.characterStyle = {
        fontSize: 10,
        fillColor: 'black'
    };
    this.edge_text.paragraphStyle.justification = 'center';
    this.edge_text.__controller = this;
    this.edge_angle = 0;
}

Rkns.Renderers.Paper__Controllers.Edge.prototype.redraw = function() {
    this.edge_line.strokeColor = this._element.created_by.color;
    var _p0 = this.from_node_controller.node_paper_coords,
        _p1 = this.to_node_controller.node_paper_coords,
        _a = _p1.subtract(_p0).angle;
    this.edge_line.segments[0].point = _p0;
    this.edge_line.segments[1].point = _p1;
    this.edge_text.content = this._element.title;
    this.edge_text.position = _p0.add(_p1).divide(2);
    if (_a > 90) {
        _a -= 180;
    }
    if (_a < -90) {
        _a += 180;
    }
    this.edge_text.rotate(_a - this.edge_angle);
    this.edge_angle = _a;
}

Rkns.Renderers.Paper__Controllers.Edge.prototype.paperShift = function(_delta) {
    this.from_node_controller.paperShift(_delta);
    this.to_node_controller.paperShift(_delta);
    this._renderer.redraw();
}

/* */

Rkns.Renderers.Paper.prototype._init = function() {
    paper.setup(document.getElementById(this._project._opts.canvas_id));
    this.scale = 1;
    this.offset = paper.view.center;
    this.totalScroll = 0;
    this.dragging_target = null;
    this.edge_layer = new paper.Layer();
    this.node_layer = new paper.Layer();
    var _tool = new paper.Tool(),
        _this = this;
    _tool.onMouseDown = function(_event) {
        _this.onMouseDown(_event);
    }
    _tool.onMouseDrag = function(_event) {
        _this.onMouseDrag(_event);
    }
    Rkns.$("#"+this._project._opts.canvas_id).mousewheel(function(_event, _delta) {
        _this.onScroll(_event, _delta);
    })
    paper.view.onResize = function(_event) {
        _this.offset = _this.offset.add(_event.delta.divide(2));
        _this.redraw();
    }
}

Rkns.Renderers.Paper.prototype.toPaperCoords = function(_point) {
    return _point.multiply(this.scale).add(this.offset);
}


Rkns.Renderers.Paper.prototype.toModelCoords = function(_point) {
    return _point.subtract(this.offset).divide(this.scale);
}

Rkns.Renderers.Paper.prototype.draw = function() {
    var _this = this,
        _xx = this._project.nodes.map(function(_node) { return _node.position.x }),
        _yy = this._project.nodes.map(function(_node) { return _node.position.y }),
        _minx = Math.min.apply(Math, _xx),
        _miny = Math.min.apply(Math, _yy),
        _maxx = Math.max.apply(Math, _xx),
        _maxy = Math.max.apply(Math, _yy);
    this.scale = Math.min((paper.view.size.width - 100) / (_maxx - _minx), (paper.view.size.height - 100) / (_maxy - _miny));
    this.offset = paper.view.center.subtract(new paper.Point([(_maxx + _minx) / 2, (_maxy + _miny) / 2]).multiply(this.scale));
    this.nodes = this._project.nodes.map(function(_node) {
        return new Rkns.Renderers.Paper__Controllers.Node(_this, _node);
    });
    this.edges = this._project.edges.map(function(_edge) {
        return new Rkns.Renderers.Paper__Controllers.Edge(_this, _edge);
    });
    
    this.redraw();
}

Rkns.Renderers.Paper.prototype.redraw = function() {
    Rkns._(this.nodes).each(function(_node) {
        _node.redraw();
    });
    Rkns._(this.edges).each(function(_edge) {
        _edge.redraw();
    });
    paper.view.draw();
}

Rkns.Renderers.Paper.prototype.onMouseDown = function(_event) {
    var _hitResult = paper.project.hitTest(_event.point);
    if (_hitResult && typeof _hitResult.item.__controller !== "undefined") {
        this.dragging_target = _hitResult.item.__controller;
    } else {
        this.dragging_target = null;
    }
}

Rkns.Renderers.Paper.prototype.onMouseDrag = function(_event) {
    if (this.dragging_target && typeof this.dragging_target.paperShift === "function") {
        this.dragging_target.paperShift(_event.delta);
    } else {
        this.offset = this.offset.add(_event.delta);
        this.redraw();
    }
}

Rkns.Renderers.Paper.prototype.onScroll = function(_event, _delta) {
    this.totalScroll += _delta;
    if (Math.abs(this.totalScroll) >= 1) {
        if (this.totalScroll > 0) {
            this.scale *= Math.SQRT2;
        } else {
            this.scale *= Math.SQRT1_2;
        }
        console.log(this.scale);
        this.totalScroll = 0;
        this.redraw();
    }
}
