/* 
 *  Copyright 2012 Institut de recherche et d'innovation 
 *  contributor(s) : Samuel Huron, Raphael Velt
 *   
 *  contact@iri.centrepompidou.fr
 *  http://www.iri.centrepompidou.fr 
 *   
 *  This software is a computer program whose purpose is to show and add annotations on a video .
 *  This software is governed by the CeCILL-C license under French law and
 *  abiding by the rules of distribution of free software. You can  use, 
 *  modify and/ or redistribute the software under the terms of the CeCILL-C
 *  license as circulated by CEA, CNRS and INRIA at the following URL
 *  "http://www.cecill.info". 
 *  
 *  The fact that you are presently reading this means that you have had
 *  knowledge of the CeCILL-C license and that you accept its terms.
*/

/* Declaring the Renkan Namespace Rkns */

Rkns = {}

Rkns.$ = jQuery;

Rkns._ = _;

Rkns.Serializers = {};

Rkns.Serializers._Base = function(_project) {
    if (typeof _project !== "undefined") {
        this._project = _project;
        this._callbackQueue = [];
        this._loaded = false;
    }
}

Rkns.Serializers._Base.prototype.deserialize = function() {}

Rkns.Serializers._Base.prototype.deferCallback = function(_callback) {
    var _this = this;
    Rkns._.defer(function() {
        _callback.call(_this);
    });
}

Rkns.Serializers._Base.prototype.handleCallbacks = function() {
    this._loaded = true;
    while (this._callbackQueue.length) {
        this.deferCallback(this._callbackQueue.splice(0,1)[0]);
    }
}

Rkns.Serializers._Base.prototype.onLoad = function(_callback) {
    if (this._loaded) {
        this.deferCallback(_callback);
    } else {
        this._callbackQueue.push(_callback);
    }
}

Rkns.Renderers = {};

Rkns.Renderers._Base = function(_project) {
    if (typeof _project !== "undefined") {
        this._project = _project;
    }
}

Rkns.Project = function(_opts) {
    if (typeof _opts.serializer == "undefined") {
        _opts.serializer = "BasicJson";
    }
    if (typeof _opts.renderer == "undefined") {
        _opts.renderer = "Paper";
    }
    this._opts = _opts;
    this.users = new Rkns.Model.List();
    this.nodes = new Rkns.Model.List();
    this.edges = new Rkns.Model.List();
    this.serializer = new Rkns.Serializers[_opts.serializer](this);
    this.renderer = new Rkns.Renderers[_opts.renderer](this);
    var _this = this;
    this.serializer.onLoad(function() {
        _this.renderer.draw();
    });
}

/* Utility functions */

Rkns.Utils = {
    _ID_AUTO_INCREMENT : 0,
    _ID_BASE : (function(_d) {
        function pad(n){return n<10 ? '0'+n : n}
        function fillrand(n) {
            var _res = ''
            for (var i=0; i<n; i++) {
                _res += Math.floor(16*Math.random()).toString(16);
            }
            return _res;
        }
        return _d.getUTCFullYear() + '-'  
            + pad(_d.getUTCMonth()+1) + '-'  
            + pad(_d.getUTCDate()) + '-'
            + fillrand(16);
    })(new Date()),
    getUID : function(_base) {
        var _n = (++this._ID_AUTO_INCREMENT).toString(16),
            _base = (typeof _base === "undefined" ? "" : _base + "-" );
        while (_n.length < 4) {
            _n = '0' + _n
        }
        return _base + this._ID_BASE + '-' + _n;
    },
    inherit : function(_baseClass, _callbefore) {
        var _class = function() {
            if (typeof _callbefore === "function") {
                _callbefore.apply(this, Array.prototype.slice.call(arguments, 0));
            }
            if (typeof _baseClass.prototype._init !== "function") {
                _baseClass.prototype._init = function() {}
            }
            _baseClass.apply(this, Array.prototype.slice.call(arguments, 0));
            this._init.apply(this, Array.prototype.slice.call(arguments, 0));
        }
        _class.prototype = new _baseClass();
        return _class;
    }
}