Rkns.Serializers.BasicJson = Rkns.Utils.inherit(Rkns.Serializers._Base);

Rkns.Serializers.BasicJson.prototype._init = function() {
    this.load(this._project._opts.url);
}

Rkns.Serializers.BasicJson.prototype.load = function(_url) {
    var _this = this;
    Rkns.$.getJSON(_url, function(_data) {
        _this.deserialize(_data);
        _this.handleCallbacks();
    });
}

Rkns.Serializers.BasicJson.prototype.deserialize = function(_serializedData) {
    if (typeof _serializedData === "string") {
        _serializedData = JSON.parse(_serializedData);
    }
    var _proj = this._project;
    _proj.title = _serializedData.title || "(untitled project)";
    if (typeof _serializedData.users === "object" && _serializedData.users) {
        _proj.users.addElements(
            Rkns._(_serializedData.users).map(function(_data) {
                var _userData = {
                    id: _data.id,
                    title: _data.title,
                    uri: _data.uri,
                    color: _data.color
                };
                return new Rkns.Model.User(_proj, _userData);
            })
        );
    }
    if (typeof _serializedData.nodes === "object" && _serializedData.nodes) {
        _proj.nodes.addElements(
            Rkns._(_serializedData.nodes).map(function(_data) {
                var _nodeData = {
                    id: _data.id,
                    title: _data.title,
                    uri: _data.uri,
                    created_by: _data.created_by,
                    position: {
                        x: _data.position.x,
                        y: _data.position.y
                        //x: 800 * Math.random() - 400,
                        //y: 600 * Math.random() - 300
                    }
                };
                return new Rkns.Model.Node(_proj, _nodeData);
            })
        );
    }
    if (typeof _serializedData.edges === "object" && _serializedData.edges) {
        _proj.edges.addElements(
            Rkns._(_serializedData.edges).map(function(_data) {
                var _edgeData = _data;
                return new Rkns.Model.Edge(_proj, _edgeData);
            })
        );
    }
}
