package org.iri_research.renkan.coweb;

//import java.util.HashMap;
import java.util.Map;

import javax.inject.Named;

import org.coweb.DefaultSessionModerator;
import org.iri_research.renkan.coweb.event.ISyncEventManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
//import javax.inject.Inject;

@Named
public class RenkanSessionModerator extends DefaultSessionModerator {
	
	private final Logger logger = LoggerFactory.getLogger(RenkanSessionModerator.class);
		
	@SuppressWarnings("unchecked")
	@Override
	public void onSync(String clientId, Map<String, Object> data) {
				
		this.logger.debug("Debugging onSync client id: " + clientId);
		this.logger.debug("Debugging onSync: " + data.toString());
		this.logger.debug("Debugging onSync channel: " + data.get("channel"));
		this.logger.debug("Debugging onSync type: " + data.get("type"));
		this.logger.debug("Debugging onSync site: " + data.get("site"));
		this.logger.debug("Debugging onSync value: " + data.get("value"));
		this.logger.debug("Debugging onSync position: " + data.get("position"));
				
		Map<String, Object> values = null;
		if(data.containsKey("value") && data.get("value") != null) {
			values = ((Map<String, Object>) data.get("value"));
		}
		
		if(values == null) {
			this.logger.warn("onSync : no values in message.");
			return;		
		}
		
		String sync_type = (String) values.get("_type");
		if(sync_type == null || sync_type.length() == 0) {
			this.logger.warn("onSync : no type in value of message.");
			return;
		}
		
		if(sync_type.startsWith("_")) {
			this.logger.debug("onSync : type sync begin with _, ignore. " + sync_type);
			return;
		}
		
		ApplicationContext context = SpringConfigurer.getInstance().getApplicationContext();
				
		String beanName = String.format("%sSyncEventManager", sync_type.toLowerCase());
		
		try {
			ISyncEventManager<?, ?> eventManager = (ISyncEventManager<?, ?>)context.getBean(beanName);
			logger.debug("Debugging on Sync : dispatch to " + beanName);
			eventManager.dispatchEvent(data);
		}
		catch(Throwable e) {
			this.logger.error(String.format("onSync EventManagerClass %s not found : error %s : %s", sync_type, e.toString(), e.getMessage()));
		}
		
	}

}
