
define(['jquery', 'underscore', 'requtils', 'renderer/nodebutton'], function ($, _, requtils, NodeButton) {
    'use strict';

    var Utils = requtils.getUtils();

    /* NodeRevertButton Begin */

    //var NodeRevertButton = Renderer.NodeRevertButton = Utils.inherit(Renderer._NodeButton);
    var NodeRevertButton = Utils.inherit(NodeButton);

    _(NodeRevertButton.prototype).extend({
        _init: function() {
            this.type = "Node-revert-button";
            this.lastSectorInner = 0;
            this.startAngle = -135;
            this.endAngle = 135;
            this.imageName = "revert";
            this.text = "Cancel deletion";
        },
        mouseup: function() {
            this.renderer.click_target = null;
            this.renderer.is_dragging = false;
            if (this.renderer.isEditable()) {
                this.source_representation.model.unset("delete_scheduled");
            }
        }
    });

    /* NodeRevertButton End */

    return NodeRevertButton;

});
