package org.iri_research.renkan.rest;

import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spring.SpringLifecycleListener;
import org.glassfish.jersey.server.spring.scope.RequestContextFilter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;

public class RestApplication extends ResourceConfig {
    
    private ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
    
    public RestApplication() {

        this.packages("org.iri_research.renkan.rest");
        this.register(SpringLifecycleListener.class);
        this.register(RequestContextFilter.class);
        
        ObjectMapper objectMapper = this.objectMapperProvider.getContext(ObjectMapper.class);
        
        JacksonJaxbJsonProvider provider = new JacksonJaxbJsonProvider(objectMapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
        
        this.register(provider);

    }
}
