
define(['jquery', 'underscore', 'requtils', 'renderer/nodebutton'], function ($, _, requtils, NodeButton) {
    'use strict';

    var Utils = requtils.getUtils();

    /* NodeRemoveButton Begin */

    //var NodeRemoveButton = Renderer.NodeRemoveButton = Utils.inherit(Renderer._NodeButton);
    var NodeHideButton = Utils.inherit(NodeButton);

    _(NodeHideButton.prototype).extend({
        _init: function() {
            this.type = "Node-hide-button";
            this.lastSectorInner = 0;
            this.startAngle = 45;
            this.endAngle = 90;
            this.imageName = "hide";
            this.text = "Hide";
        },
        mouseup: function() {
            this.renderer.click_target = null;
            this.renderer.is_dragging = false;
            this.renderer.removeRepresentationsOfType("editor");
            if (this.renderer.isEditable()) {
                this.renderer.view.addHiddenNode(this.source_representation.model);
            }
        }
    }).value();

    /* NodeRemoveButton End */

    return NodeHideButton;

});
