import os
import sys

from setuptools import setup, find_packages

# Dynamically calculate the version based on django.VERSION.
version = __import__('renkanmanager').get_version()

def launch_setup(script_name, script_args):

    setup(
        script_name = script_name,
        script_args = script_args,
        name='renkanmanager',
        version=version,
        url='http://renkan.iri-research.org/',
        author='I.R.I.',
        author_email='contact@iri-research.org',
        description=('Basic Django module for saving renkan'),
        license='CECILL-B',
        packages=find_packages(),
        include_package_data=True,
        zip_safe=False,
        classifiers=[
            'Development Status :: 3 - Alpha',
            'Environment :: Web Environment',
            'Framework :: Django',
            'Intended Audience :: Developers',
            'License :: OSI Approved :: CECILL License',
            'Operating System :: OS Independent',
            'Programming Language :: Python',
            'Programming Language :: Python :: 2',
            'Programming Language :: Python :: 2.7',
            'Topic :: Internet :: WWW/HTTP',
            'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
            'Topic :: Internet :: WWW/HTTP :: WSGI',
            'Topic :: Software Development :: Libraries :: Python Modules',
        ],
    )
    
if __name__ == "__main__":
    
    script_name = os.path.basename(sys.argv[0])
    script_args = sys.argv[1:]
    
    launch_setup(script_name, script_args)
