package org.iri_research.renkan.rest;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.ws.rs.Path;

import org.iri_research.renkan.Constants;
import org.iri_research.renkan.models.Project;
import org.iri_research.renkan.repositories.IRenkanRepository;
import org.iri_research.renkan.repositories.ProjectsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.sun.jersey.spi.resource.Singleton;


@Singleton
@Path("projects")
@Component
public class ProjectsResource extends RenkanResource<Project, String> {
	
	@SuppressWarnings("unused")
	private Logger logger = LoggerFactory.getLogger(ProjectsResource.class);
	
	@Autowired
	private ProjectsRepository projectsRepository;

	@Override
	protected IRenkanRepository<Project, String> getRepository() {
		return this.projectsRepository;
	}

	@Override
	protected String getNewId() {
		return Constants.UUID_GENERATOR.generate().toString();
	}

	@Override
	protected void prepareObject(Project obj) {
		if(obj.getCreated() == null) {
			obj.setCreated(new Date());
		}
		obj.setUpdated(new Date());
	}

	@Override
	protected List<String> getObjectListFieldList() {
		return Arrays.asList(this.baseObjectListFieldList);
	}	
	
	@Override
	protected void doDeleteObject(String objectId) {
		this.projectsRepository.deleteRecursive(objectId);
	}

}
