/*
 * Decompiled with CFR 0.152.
 */
package org.coweb;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerSession;
import org.coweb.SessionModerator;
import org.coweb.bots.transport.Transport;

public class ServiceHandler {
    private static final Logger log = Logger.getLogger(ServiceHandler.class.getName());
    private String sessionId = null;
    private Map<String, Transport> brokers = new HashMap<String, Transport>();
    private Map<String, Object> cowebConfig = null;

    public ServiceHandler(String sessionId, Map<String, Object> config) {
        log.info("ServiceHandler new Instance " + sessionId);
        this.sessionId = sessionId;
        this.cowebConfig = config;
    }

    public Transport getServiceBroker(String serviceName) {
        log.fine("ServiceHandler::getServiceBroker for " + serviceName);
        Transport broker = this.brokers.get(serviceName);
        if (broker != null) {
            return broker;
        }
        log.fine(this.cowebConfig.get("bots").toString());
        Object[] botConfigs = (Object[])this.cowebConfig.get("bots");
        if (botConfigs == null) {
            return null;
        }
        Map botConfig = null;
        for (int i = 0; i < botConfigs.length; ++i) {
            Map tmp = (Map)botConfigs[i];
            String s = (String)tmp.get("service");
            if (!s.equals(serviceName)) continue;
            botConfig = tmp;
            break;
        }
        if (botConfig == null) {
            return null;
        }
        String brokerStr = (String)botConfig.get("broker");
        if (brokerStr == null) {
            if (botConfig.get("class") != null) {
                brokerStr = "org.coweb.bots.transport.LocalTransport";
            } else {
                return null;
            }
        }
        try {
            Class<Transport> clazz = Class.forName(brokerStr).asSubclass(Transport.class);
            broker = clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        broker.setBotConfig(botConfig);
        broker.setSessionId(this.sessionId);
        this.brokers.put(serviceName, broker);
        return broker;
    }

    public void removeUserFromAll(ServerSession client) {
        for (Transport t : this.brokers.values()) {
            try {
                t.unsubscribeUser(client, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdown() {
        log.fine("ServiceHandler::shutdown");
        for (Transport transport : this.brokers.values()) {
            transport.shutdown();
        }
        this.brokers.clear();
    }

    public void subscribeUser(ServerSession client, Message message) throws IOException {
        String serviceName;
        log.fine("ServiceHandler::subscribeUser");
        String channel = (String)message.get((Object)"subscription");
        boolean pub = true;
        if (channel.startsWith("/service")) {
            pub = false;
        }
        if ((serviceName = ServiceHandler.getServiceNameFromSubscription(message, pub)) == null) {
            throw new IOException("improper subscription to channel " + message.getChannel());
        }
        Transport broker = this.getServiceBroker(serviceName);
        if (broker == null) {
            throw new IOException("no broker to handle this service " + serviceName);
        }
        broker.subscribeUser(client, pub);
    }

    public void subscribeModerator(SessionModerator mod, String serviceName) throws IOException {
        Transport broker = this.getServiceBroker(serviceName);
        if (broker == null) {
            throw new IOException("no broker to handle this service " + serviceName);
        }
        broker.subscribeUser(mod.getServerSession(), true);
    }

    public void userCannotSubscribe(ServerSession client, Message message) throws IOException {
        String serviceName;
        Transport broker;
        String channel = (String)message.get((Object)"subscription");
        boolean pub = true;
        if (channel.startsWith("/service")) {
            pub = false;
        }
        if (null == (broker = this.getServiceBroker(serviceName = ServiceHandler.getServiceNameFromSubscription(message, pub)))) {
            throw new IOException("no broker to handle this service " + serviceName);
        }
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("error", true);
        ServerChannel ch = broker.getResponseChannel();
        client.deliver((Session)broker.getServer(), ch.getId(), data, null);
    }

    public void unSubscribeUser(ServerSession client, Message message) throws IOException {
        String serviceName;
        log.fine("ServiceHandler::unSubscribeUser");
        String channel = (String)message.get((Object)"subscription");
        boolean pub = true;
        if (channel.startsWith("/service")) {
            pub = false;
        }
        if ((serviceName = ServiceHandler.getServiceNameFromSubscription(message, pub)) == null) {
            throw new IOException("improper subscription to channel " + message.getChannel());
        }
        Transport broker = this.getServiceBroker(serviceName);
        if (broker == null) {
            throw new IOException("no broker to handle this service " + serviceName);
        }
        broker.unsubscribeUser(client, pub);
    }

    public void userCannotPost(ServerSession client, Message message) throws IOException {
        String serviceName = ServiceHandler.getServiceNameFromMessage(message, false);
        if (serviceName == null) {
            throw new IOException("improper request channel " + message.getChannel());
        }
        Transport broker = this.getServiceBroker(serviceName);
        if (broker == null) {
            throw new IOException("no broker to handle this service " + serviceName);
        }
        Map data = message.getDataAsMap();
        String replyToken = (String)data.get("topic");
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("error", true);
        resp.put("topic", replyToken);
        client.deliver((Session)broker.getServer(), "/service/bot/" + broker.getServiceName() + "/response", resp, null);
    }

    public void forwardUserRequest(ServerSession client, Message message) throws IOException {
        log.info(message.toString());
        String serviceName = ServiceHandler.getServiceNameFromMessage(message, false);
        if (serviceName == null) {
            throw new IOException("improper request channel " + message.getChannel());
        }
        Transport broker = this.getServiceBroker(serviceName);
        if (broker == null) {
            throw new IOException("no broker to handle this service " + serviceName);
        }
        broker.userRequest(client, message);
    }

    public static String getServiceNameFromSubscription(Message message, boolean pub) {
        String channel = (String)message.get((Object)"subscription");
        return ServiceHandler.getServiceNameFromChannel(channel, pub);
    }

    public static String getServiceNameFromSubscription(Message message) {
        String channel = (String)message.get((Object)"subscription");
        return ServiceHandler.getServiceNameFromChannel(channel, ServiceHandler.isPublicBroadcast(channel));
    }

    public static String getServiceNameFromMessage(Message message, boolean pub) {
        String channel = message.getChannel();
        return ServiceHandler.getServiceNameFromChannel(channel, pub);
    }

    public static String getServiceNameFromMessage(Message message) {
        String channel = message.getChannel();
        return ServiceHandler.getServiceNameFromChannel(channel, ServiceHandler.isPublicBroadcast(channel));
    }

    public static String getServiceNameFromChannel(String channel, boolean pub) {
        String[] parts = channel.split("/");
        String serviceName = null;
        if (pub) {
            if (parts.length == 3) {
                serviceName = parts[2];
            }
        } else if (parts.length == 5 && (parts[4].equals("request") || parts[4].equals("response"))) {
            serviceName = parts[3];
        }
        return serviceName;
    }

    public static String getServiceNameFromChannel(String channel) {
        return ServiceHandler.getServiceNameFromChannel(channel, ServiceHandler.isPublicBroadcast(channel));
    }

    public static boolean isPublicBroadcast(String channel) {
        return !channel.startsWith("/service");
    }

    public static boolean isPublicBroadcast(Message message) {
        String channel = message.getChannel();
        return !channel.startsWith("/service");
    }

    public static boolean isServiceMessage(Message message) {
        String channel = message.getChannel();
        return channel.startsWith("/service/bot") || channel.startsWith("/bot");
    }
}

