(function(root) {

    "use strict";

    var DataLoader = root.Rkns.DataLoader = {
        converters: {
            from1to2: function(data) {

                //TODO: implement

                return data;
            }
        }
    };


    DataLoader.Loader = function(project, options) {
        this.project = project;
        this.dataConverters = _.defaults(options.converters || {}, DataLoader.converters);
    };


    DataLoader.Loader.prototype.convert = function(data) {
        var schemaVersionFrom = this.project.getSchemaVersion(data);
        var schemaVersionTo = this.project.getSchemaVersion();

        if (schemaVersionFrom !== schemaVersionTo) {
            var converterName = "from" + schemaVersionFrom + "to" + schemaVersionTo;
            if (typeof this.dataConverters[converterName] === 'function') {
                data = this.dataConverters[converterName](data);
            }
        }
        return data;
    };

    DataLoader.Loader.prototype.load = function(data) {
        console.log(data);
        this.project.set(this.convert(data), {
            validate: true
        });
    };

})(window);
