# -*- coding: utf-8 -*-
# Generated by Django 1.9.4 on 2016-06-21 08:09
from __future__ import unicode_literals

import json

from django.db import migrations

def adjust_rev_modification_date(apps, schema_editor):
    Revision = apps.get_model('renkanmanager', 'Revision')

    for rev in Revision.objects.all():
        content =  json.loads(rev.content)
        if rev.modification_date:
            content['updated'] = rev.modification_date.isoformat(' ')
            rev.content = json.dumps(content)
            rev.save()

class Migration(migrations.Migration):

    dependencies = [
        ('renkanmanager', '0007_foreign_key_final'),
    ]

    operations = [
        migrations.RunPython(adjust_rev_modification_date)
    ]
