# Renkan - Client configuration

Renkan is a tool to simply build oriented graphs by creating nodes and drag'n'droping links, 
pictures and html elements from web pages. Each node can have title, description, uri/url, color, 
image and specific size. Each node can have title, uri/url and color.


## Embedding Renkan in a web page

Whatever configuration you have, you need to import those javascript files **in that order**...

    <script src="[...]/jquery.min.js"></script>
    <script src="[...]/jquery.mousewheel.min.js"></script>
    <script src="[...]/underscore-min.js"></script>
    <script src="[...]/backbone.js"></script>
    <script src="[...]/backbone-relational.js"></script>
    <script src="[...]/paper.js"></script>
    <script src="[...]/renkan.js"></script>

... and the renkan css file :

    <link rel="stylesheet" href="[...]/renkan.css" />

Finally, add the div in you DOM :

    <div id="renkan"></div>

Your Renkan should be displayed. Now let's see more specifically the 2 displays possibilities : in body 100% or in a div with set width and height.

N.B. : renkan.js is the concatenation of those js files : header.js main.js models.js defaults.js i18n.js paper-renderer.js full-json.js ldtjson-bin.js list-bin.js wikipedia-bin.js.
It is built with the script available in sbin/build/compil.sh. 

### In body 100%

Nothing to add, the html is very simple :

    <body>
        <div id="renkan"></div>
    </body>


### In a div

The renkan div has the css attributes position:absolute/top:0/left:0/bottom:0/right:0, 
so the parent div has to be in position:relative and define width and height. Here is a simple example including css and partial html :

    <head>
      <style type="text/css">
        body{
            margin: 0 auto;
            width: 960px;
        }
        .header, .footer {
            font-size: 14px;
            height: 40px;
            padding-top: 10px;
        }
        .rnk-container{
            height: 500px;
            position: relative;
            width: 700px;
        }
      </style>
    </head>
    <body>
      <div class="header">
        This is a header
      </div>
      <div class="rnk-container">
         <div id="renkan"></div>
      </div>
      <div class="footer">
        This is a footer
      </div>
    </body>


## Embedding a read only Renkan

To embed a read only Renkan, just add this script tag :

    <script type="text/javascript">
        var _renkan;
        $(function() {
            _renkan = new Rkns.Renkan({
                editor_mode: false,
                show_bins: false,
            });
            Rkns.jsonIO(_renkan, {
                url: "any_local_or_jsonp_url"
            });
        });
    </script>



## Embedding a writable Renkan

### Simple mode : no bins on the left, just the canvas

To embed a simple writable Renkan, just add this script tag. In the client folder, "data/simple-persist.php" makes a very simple persistent url. 
The persistent url is supposed to give the json data on GET request at page load, and save datas at PUT request sent by the browser :

    <script type="text/javascript">
        var _renkan;
        $(function() {
            _renkan = new Rkns.Renkan({
                show_bins: false
            });
            Rkns.jsonIO(_renkan, {
                url: "url_of_a_persistent_connection"
            });
        });
    </script>


## Search and bins

On the right of your renkan interface, you can add some search engine and data bins.

Search engine can be the current [IRI's Lignes de temps platform](http://ldt.iri.centrepompidou.fr/) and wikipedia in any available language. 
Here is an example of configuration :

    _renkan = new Rkns.Renkan({
        search: [
                {
                    type: "Ldt"
                },
                {
                    type: "Wikipedia",
                    lang: "fr"
                },
                {
                    type: "Wikipedia",
                    lang: "ja"
                }
        ]
    });
    Rkns.jsonIO(_renkan, {
        url: "data/simple-persist.php"
    });

You can also define data bins : annotations loaded from IRI's Lignes de temps projects, and any resources which can be drag and dropped into the renkan.
Resources can be simple texts, links or objects with title, description, url and image. Here is an example of configuration :

    _renkan = new Rkns.Renkan({
        search: [
            ...
        ],
        bins: [
            {
                title: "To be or not to be on Lignes de Temps",
                type: "Ldt",
                ldt_type: "Project",
                project_id: "6af4019c-8283-11e2-9678-00145ea4a2be",
                ldt_platform: "http://ldt.iri.centrepompidou.fr/"
            },
            {
                type: "ResourceList",
                title: "Ressources",
                list: [
                    {
                        url: "http://www.google.com/",
                        title: "Google",
                        description: "Search engine",
                        image: "http://www.google.fr/images/srpr/logo4w.png"
                    },
                    "Polemic Tweet http://www.polemictweet.com",
                    "Twitter http://www.twitter.com/"
                ]
            }
        ]
    });
    Rkns.jsonIO(_renkan, {
        url: "data/simple-persist.php"
    });


## More configuration

You can configure several things :
* the language of your interface, english (default) or french
* you can fill your nodes with black color instead of transparent.
* thanks to an external file, you can define properties for links between node.


    _renkan = new Rkns.Renkan({
        ...
        property_files: [ "data/properties.json" ],
        node_fill_color: true,
        language: "fr"
    });

Here is an example of properties file :

    [
        {
            "label": "Dublin Core Metadata",
            "base-uri": "http://purl.org/dc/elements/1.1/",
            "properties": [
                {
                    "uri": "creator",
                    "label": "created by"
                }, {
                    "uri": "date",
                    "label": "has date"
                }, {
                    "uri": "subject",
                    "label": "has subject"
                }
            ]
        }, {
            "label": "SKOS Semantic relations",
            "base-uri": "http://www.w3.org/2004/02/skos/core#",
            "properties": [
                {
                    "uri": "broader",
                    "label": "has broader"
                }, {
                    "uri": "narrower",
                    "label": "has narrower"
                }, {
                    "uri": "related",
                    "label": "has related"
                }
            ]
        }
    ]



Finally, here is an example of full configuration :

    <script type="text/javascript">
        var _renkan;
        $(function() {
            _renkan = new Rkns.Renkan({
                search: [
                    {
                        type: "Ldt"
                    },
                    {
                        type: "Wikipedia",
                        lang: "fr"
                    },
                    {
                        type: "Wikipedia",
                        lang: "ja"
                    }
                ],
                bins: [
                    {
                        title: "Projet Lignes de Temps",
                        type: "Ldt",
                        ldt_type: "Project",
                        project_id: "6af4019c-8283-11e2-9678-00145ea4a2be",
                        ldt_platform: "http://ldt.iri.centrepompidou.fr/"
                   },
                    {
                        type: "ResourceList",
                        title: "Ressources",
                        list: [
                            {
                                url: "http://www.google.com/",
                                title: "Google",
                                description: "Search engine",
                                image: "http://www.google.fr/images/srpr/logo4w.png"
                            },
                            "Polemic Tweet http://www.polemictweet.com",
                            "Twitter http://www.twitter.com/"
                        ]
                    }
                ],
                property_files: [ "data/properties.json" ],
                node_fill_color: false,
                language: "fr"
            });
            Rkns.jsonIO(_renkan, {
                url: "data/simple-persist.php"
            });
        });
    </script>