package org.iri_research.renkan;

import java.util.Properties;

import javax.annotation.Resource;
import javax.inject.Named;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class RenkanProperties {

    @Resource(name = "renkanProperties")
    private Properties properties;

    private final Logger logger = LoggerFactory
            .getLogger(RenkanProperties.class);

    private static volatile RenkanProperties instance = null;

    private RenkanProperties() {
        this.logger.debug("Building RenkanProperties");
    }

    public static RenkanProperties getInstance() {
        if (instance == null) {
            synchronized (RenkanProperties.class) {
                if (instance == null) {
                    instance = new RenkanProperties();
                }
            }
        }
        return instance;
    }

    public int getPaginationSize() {
        return Integer.parseInt(properties.getProperty(
                "renkan.pagination.size",
                Integer.toString(Constants.PAGINATION_SIZE)));
    }

    public String getProperty(String name, String defaultVal) {
        return properties.getProperty(name, defaultVal);
    }

}
