/*
 * Decompiled with CFR 0.152.
 */
package org.coweb;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.coweb.CowebException;
import org.coweb.LateJoinHandler;
import org.coweb.ModeratorLateJoinHandler;
import org.coweb.OperationEngineHandler;
import org.coweb.ServiceHandler;
import org.coweb.SessionManager;
import org.coweb.SessionModerator;
import org.coweb.oe.OperationEngineException;

public class SessionHandler
implements ServerChannel.MessageListener {
    private static final String sendOnceKey = "698e141094de24baec7998994d6d32f4";
    private static final Logger log = Logger.getLogger(SessionHandler.class.getName());
    private String confKey = null;
    private boolean cacheState = false;
    private String sessionId = null;
    private ServiceHandler serviceHandler = null;
    private BayeuxServer server = null;
    private LateJoinHandler lateJoinHandler = null;
    private SessionModerator sessionModerator = null;
    private OperationEngineHandler operationEngine = null;
    private SessionManager manager;
    private LinkedList modSyncQueue = new LinkedList();
    private Semaphore modSyncSem = new Semaphore(1);
    private AtomicInteger order = new AtomicInteger(0);
    private String syncAppChannel = null;
    private String syncEngineChannel = null;
    private String rosterAvailableChannel = null;
    private String rosterUnavailableChannel = null;
    private String botRequestChannel = null;
    private String requestUrl = null;
    private String sessionName = null;
    private ArrayList<ServerSession> attendees = new ArrayList();

    public SessionHandler(String confkey, boolean cacheState, Map<String, Object> config) {
        boolean useEngine;
        this.confKey = confkey;
        this.cacheState = cacheState;
        this.sessionId = SessionHandler.hashURI(confkey);
        this.serviceHandler = new ServiceHandler(this.sessionId, config);
        this.manager = SessionManager.getInstance();
        this.server = this.manager.getBayeux();
        this.syncAppChannel = "/session/" + this.sessionId + "/sync/app";
        this.syncEngineChannel = "/session/" + this.sessionId + "/sync/engine";
        this.rosterAvailableChannel = "/session/" + this.sessionId + "/roster/available";
        this.rosterUnavailableChannel = "/session/" + this.sessionId + "/roster/unavailable";
        this.botRequestChannel = "/service/bot/%s/request";
        ConfigurableServerChannel.Initializer initializer = new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.setPersistent(true);
                channel.setLazy(false);
            }
        };
        this.server.createIfAbsent(this.syncAppChannel, new ConfigurableServerChannel.Initializer[]{initializer});
        this.server.createIfAbsent(this.syncEngineChannel, new ConfigurableServerChannel.Initializer[]{initializer});
        ServerChannel sync = this.server.getChannel(this.syncAppChannel);
        sync.addListener((ConfigurableServerChannel.ServerChannelListener)this);
        sync = this.server.getChannel(this.syncEngineChannel);
        sync.addListener((ConfigurableServerChannel.ServerChannelListener)this);
        this.sessionModerator = SessionModerator.getInstance(this, (String)config.get("sessionModerator"), this.confKey);
        if (null == this.sessionModerator) {
            config.put("moderatorIsUpdater", false);
            log.severe("SessionModerator.getInstance(" + config.get("sessionModerator") + ") failed, reverting to " + "trying to create default implementation.");
            this.sessionModerator = SessionModerator.getInstance(this, null, this.confKey);
            if (null == this.sessionModerator) {
                throw new CowebException("Create SessionModerator", "");
            }
            log.severe("SessionModerator created default implementation, but moderator can no longer be updater.");
        }
        boolean mustUseEngine = false;
        LateJoinHandler lh = null;
        if (config.containsKey("moderatorIsUpdater") && ((Boolean)config.get("moderatorIsUpdater")).booleanValue()) {
            mustUseEngine = true;
            lh = new ModeratorLateJoinHandler(this, config);
        } else {
            log.info("creating LateJoinHandler");
            lh = new LateJoinHandler(this, config);
        }
        this.lateJoinHandler = lh;
        boolean bl = useEngine = config.containsKey("operationEngine") && (Boolean)config.get("operationEngine") != false;
        if (!useEngine && mustUseEngine) {
            log.warning("Must use OperationEngine because moderatorIsUpdater==true, even though operationEngine is not set.");
            useEngine = true;
        }
        if (useEngine) {
            LocalSession modSession = this.sessionModerator.getLocalSession();
            Integer siteId = (Integer)modSession.getAttribute("siteid");
            try {
                log.info("creating operation engine with siteId = " + siteId);
                this.operationEngine = new OperationEngineHandler(this, siteId);
            }
            catch (OperationEngineException e) {
                e.printStackTrace();
            }
        } else {
            log.info("No op engine for this session");
        }
    }

    public SessionModerator getSessionModerator() {
        return this.sessionModerator;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String url) {
        this.requestUrl = url;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String name) {
        this.sessionName = name;
    }

    public ServiceHandler getServiceHandler() {
        return this.serviceHandler;
    }

    public ArrayList<ServerSession> getAttendees() {
        return this.attendees;
    }

    public String getRosterAvailableChannel() {
        return this.rosterAvailableChannel;
    }

    public String getRosterUnavailableChannel() {
        return this.rosterUnavailableChannel;
    }

    public String getConfKey() {
        return this.confKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isCachingState() {
        return this.cacheState;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{\"confkey\":");
        sb.append(this.confKey);
        sb.append(",\"sessionid\":");
        sb.append(this.sessionId);
        sb.append("}");
        return sb.toString();
    }

    public ServerSession getServerSessionFromSiteid(String siteStr) {
        return this.lateJoinHandler.getServerSessionFromSiteid(siteStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
        Integer siteId = (Integer)from.getAttribute("siteid");
        String msgSessionId = (String)from.getAttribute("sessionid");
        if (!msgSessionId.equals(this.sessionId)) {
            log.severe("Received message not belonging to this session " + msgSessionId);
            return true;
        }
        Map data = message.getDataAsMap();
        if (data.get("__alreadySent") == sendOnceKey) {
            data.remove("__alreadySent");
            return true;
        }
        this.lateJoinHandler.clearCacheState();
        data.put("siteId", siteId);
        String channelName = message.getChannel();
        if (channelName.equals(this.syncAppChannel)) {
            data.put("order", this.order.getAndIncrement());
            if (this.operationEngine != null) {
                OperationEngineHandler operationEngineHandler = this.operationEngine;
                synchronized (operationEngineHandler) {
                    return this.doAppSync(from, channel, message, data);
                }
            }
        } else if (channelName.equals(this.syncEngineChannel)) {
            if (this.operationEngine != null) {
                OperationEngineHandler operationEngineHandler = this.operationEngine;
                synchronized (operationEngineHandler) {
                    this.operationEngine.engineSyncInbound(data);
                }
            }
        } else {
            log.warning("onMessage does not handle channel messages '" + channelName + "'\n    message = " + message);
        }
        return true;
    }

    private boolean doAppSync(ServerSession from, ServerChannel channel, ServerMessage.Mutable message, Map<String, Object> data) {
        Map<String, Object> syncEvent = this.operationEngine.syncInbound(data);
        if (syncEvent != null) {
            try {
                this.modSyncSem.acquire();
            }
            catch (InterruptedException ie) {
                log.warning("onMessage interrupted, won't deliver sync to moderator or other listeners");
                return false;
            }
            this.sessionModerator.onSync(from.getId(), syncEvent);
            data.put("__alreadySent", sendOnceKey);
            channel.publish((Session)from, message);
            this.flushModeratorQueue();
            this.modSyncSem.release();
            return false;
        }
        return true;
    }

    public void onPublish(ServerSession remote, Message message) {
        String channel = message.getChannel();
        try {
            if (channel.startsWith("/service/bot")) {
                String svcName = ServiceHandler.getServiceNameFromMessage(message, false);
                Map botData = message.getDataAsMap();
                botData = (Map)botData.get("value");
                if (this.sessionModerator.getServerSession() == remote || this.sessionModerator.canClientMakeServiceRequest(svcName, remote.getId(), botData)) {
                    this.serviceHandler.forwardUserRequest(remote, message);
                } else {
                    this.serviceHandler.userCannotPost(remote, message);
                }
            } else if (channel.equals("/service/session/updater")) {
                this.lateJoinHandler.onUpdaterSendState(remote, message);
            } else {
                log.warning("onPublish doesn't handle '" + channel + "' messages\n  message = " + message);
            }
        }
        catch (Exception e) {
            log.severe("error receiving publish message");
            log.severe(message.getJSON());
            e.printStackTrace();
        }
    }

    public void onSubscribe(ServerSession serverSession, Message message) throws IOException {
        String channel = (String)message.get((Object)"subscription");
        if (channel.equals("/service/session/join/*")) {
            Map userDefined = (Map)message.getExt().get("userDefined");
            if (this.sessionModerator.canClientJoinSession(serverSession.getId(), userDefined)) {
                if (this.lateJoinHandler.onClientJoin(serverSession, message)) {
                    this.sessionModerator.onSessionReady();
                }
            } else {
                this.sendError(serverSession, "join-disallowed");
            }
        } else if (channel.startsWith("/service/bot") || channel.startsWith("/bot")) {
            boolean pub = true;
            if (channel.startsWith("/service")) {
                pub = false;
            }
            String svcName = ServiceHandler.getServiceNameFromMessage(message, pub);
            if (this.sessionModerator.getServerSession() == serverSession || this.sessionModerator.canClientSubscribeService(svcName, serverSession.getId())) {
                this.serviceHandler.subscribeUser(serverSession, message);
            } else {
                this.serviceHandler.userCannotSubscribe(serverSession, message);
            }
        } else if (channel.endsWith("/session/updater")) {
            log.info("client subscribes to /session/updater");
            this.attendees.add(serverSession);
            this.lateJoinHandler.onUpdaterSubscribe(serverSession, message);
            this.sessionModerator.onClientJoinSession(serverSession.getId());
        }
    }

    void subscribeModeratorToService(String svcName) {
        try {
            this.serviceHandler.subscribeModerator(this.sessionModerator, svcName);
        }
        catch (Exception e) {
            log.severe("error subscribing moderator to service " + svcName);
            e.printStackTrace();
        }
    }

    private void sendError(ServerSession client, String topic) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("topic", topic);
        client.deliver((Session)this.manager.getServerSession(), "/session/error", map, null);
    }

    public void onUnsubscribe(ServerSession serverSession, Message message) throws IOException {
        String channel = (String)message.get((Object)"subscription");
        if (channel.startsWith("/service/bot") || channel.startsWith("/bot")) {
            this.serviceHandler.unSubscribeUser(serverSession, message);
        }
    }

    public void onPurgingClient(ServerSession client) {
        this.attendees.remove(client);
        this.sessionModerator.onClientLeaveSession(client.getId());
        boolean last = this.lateJoinHandler.onClientRemove(client);
        if (last) {
            this.endSession();
        }
    }

    public static String hashURI(String url) {
        String hash = null;
        try {
            String t = Long.toString(System.currentTimeMillis());
            url = url + t;
            byte[] bytes = url.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(bytes);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                sb.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
            }
            hash = sb.toString();
        }
        catch (Exception e) {
            hash = url;
        }
        return hash;
    }

    public void removeBadClient(ServerSession client) {
    }

    public void endSession() {
        log.info("SessionHandler::endSession ***********");
        ServerChannel sync = this.server.getChannel(this.syncAppChannel);
        sync.removeListener((ConfigurableServerChannel.ServerChannelListener)this);
        sync = this.server.getChannel(this.syncEngineChannel);
        sync.removeListener((ConfigurableServerChannel.ServerChannelListener)this);
        this.sessionModerator.endSession();
        if (null != this.operationEngine) {
            this.operationEngine.shutdown();
        }
        this.lateJoinHandler.onEndSession();
        this.serviceHandler.shutdown();
        this.sessionModerator = null;
        this.operationEngine = null;
        this.lateJoinHandler = null;
        this.serviceHandler = null;
        this.manager.removeSessionHandler(this);
    }

    public void postEngineSync(Integer[] sites) {
        ServerChannel sync = this.server.getChannel(this.syncEngineChannel);
        HashMap<String, Integer[]> data = new HashMap<String, Integer[]>();
        data.put("context", sites);
        sync.publish((Session)this.sessionModerator.getLocalSession(), data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getEngineState() {
        Object[] ret;
        OperationEngineHandler operationEngineHandler = this.operationEngine;
        synchronized (operationEngineHandler) {
            ret = this.operationEngine.getEngineState();
        }
        return ret;
    }

    public void publishModeratorSync(String name, Object value, String type, int position) {
        this.operationEngine.localSync(name, value, type, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendModeratorSync(Object message) {
        LinkedList linkedList = this.modSyncQueue;
        synchronized (linkedList) {
            this.modSyncQueue.push(message);
        }
        if (this.modSyncSem.tryAcquire()) {
            this.flushModeratorQueue();
            this.modSyncSem.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushModeratorQueue() {
        ServerChannel channel = this.server.getChannel(this.syncAppChannel);
        LinkedList linkedList = this.modSyncQueue;
        synchronized (linkedList) {
            for (Object message : this.modSyncQueue) {
                channel.publish((Session)this.sessionModerator.getLocalSession(), message, null);
            }
            this.modSyncQueue.clear();
        }
    }

    private ServerChannel getServiceRequestChannel(String svc) {
        String ch = String.format(this.botRequestChannel, svc);
        this.server.createIfAbsent(ch, new ConfigurableServerChannel.Initializer[0]);
        return this.server.getChannel(ch);
    }

    public void postModeratorService(String service, String topic, Map<String, Object> params) {
        ServerChannel channel = this.getServiceRequestChannel(service);
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("value", params);
        message.put("topic", topic);
        message.put("service", service);
        channel.publish((Session)this.sessionModerator.getLocalSession(), message, null);
    }
}

