package org.iri_research.renkan.services;

import java.util.List;

import org.iri_research.renkan.models.User;
import org.iri_research.renkan.repositories.UsersRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class RenkanUserDetailsService implements UserDetailsService {

    @Autowired
    private UsersRepository usersRepository;

    @Override
    public UserDetails loadUserByUsername(String username)
            throws UsernameNotFoundException {
        List<User> res = this.usersRepository.findByTitle(username);
        if (res == null || res.size() == 0) {
            throw new UsernameNotFoundException(String.format(
                    "User {0} not found.", username));
        }
        return res.get(0);
    }

}
