/*
 * Decompiled with CFR 0.152.
 */
package org.coweb.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.coweb.CowebException;
import org.coweb.CowebExtension;
import org.coweb.CowebSecurityPolicy;
import org.coweb.SessionHandler;
import org.coweb.SessionManager;
import org.eclipse.jetty.util.ajax.JSON;

public class AdminServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AdminServlet.class.getName());
    public static final String SESSMGR_ATTRIBUTE = "session.attribute";
    private SessionManager sessionManager = null;

    public void init() throws ServletException {
        super.init();
        ServletContext servletContext = this.getServletContext();
        BayeuxServer bayeux = (BayeuxServer)servletContext.getAttribute("org.cometd.bayeux");
        bayeux.addExtension((BayeuxServer.Extension)new AcknowledgedMessagesExtension());
        ServletConfig config = this.getServletConfig();
        Map<String, Object> cowebConfig = null;
        try {
            cowebConfig = this.getCowebConfigOptions(config);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            cowebConfig = new HashMap<String, Object>();
        }
        int logLevel = 0;
        if (cowebConfig.get("logLevel") != null) {
            Long level = (Long)cowebConfig.get("logLevel");
            logLevel = level.intValue();
        }
        Logger parentLogger = Logger.getLogger("org.coweb");
        parentLogger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        parentLogger.addHandler(consoleHandler);
        switch (logLevel) {
            case 0: {
                parentLogger.setLevel(Level.WARNING);
                consoleHandler.setLevel(Level.WARNING);
                break;
            }
            case 1: {
                parentLogger.setLevel(Level.INFO);
                consoleHandler.setLevel(Level.INFO);
                break;
            }
            case 2: {
                parentLogger.setLevel(Level.FINE);
                consoleHandler.setLevel(Level.FINE);
            }
        }
        log.info("servlet init");
        log.info("cowebConfig = " + cowebConfig.toString());
        String captureIncoming = (String)cowebConfig.get("captureIncoming");
        String captureOutgoing = (String)cowebConfig.get("captureOutgoing");
        if (captureIncoming != null || captureOutgoing != null) {
            try {
                CowebExtension cowebExtension = new CowebExtension(captureIncoming, captureOutgoing);
                bayeux.addExtension((BayeuxServer.Extension)cowebExtension);
            }
            catch (Exception e) {
                log.info(e.getMessage());
            }
        }
        bayeux.setSecurityPolicy((SecurityPolicy)new CowebSecurityPolicy());
        this.sessionManager = SessionManager.newInstance(cowebConfig, bayeux);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.fine("AdminServlet::gotGet ***********");
        log.fine(req.getRequestURL().toString());
        log.info("received admin rest call");
        if (req.getRequestURL().indexOf("disconnect") != -1) {
            log.info("received disconnect rest call");
            this._handleDisconnect(req, resp);
            return;
        }
        if (req.getRequestURL().indexOf("sessions") != -1) {
            log.info("received sessions rest call");
            ArrayList sessionsList = new ArrayList();
            HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
            Collection<SessionHandler> sessions = this.sessionManager.getAllSessions();
            int length = 0;
            if (sessions != null) {
                length = sessions.size();
                for (SessionHandler sessionHandler : sessions) {
                    HashMap<String, String> sessionJson = new HashMap<String, String>();
                    sessionJson.put("requestUrl", sessionHandler.getRequestUrl());
                    sessionJson.put("confKey", sessionHandler.getConfKey());
                    sessionJson.put("sessionName", sessionHandler.getSessionName());
                    sessionsList.add(sessionJson);
                }
            }
            ret.put("sessions", sessionsList);
            ret.put("length", new Integer(length));
            String jsonStr = JSON.toString(ret);
            PrintWriter writer = resp.getWriter();
            writer.print(jsonStr);
            writer.flush();
            return;
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SessionHandler handler;
        log.info("received prep request");
        resp.setContentType("appliation/json");
        String username = req.getRemoteUser();
        if (username == null) {
            username = "anonymous";
        }
        Map jsonObj = null;
        boolean cacheState = false;
        try {
            jsonObj = (Map)JSON.parse((Reader)req.getReader());
            if (jsonObj.containsKey("cacheState") && ((Boolean)jsonObj.get("cacheState")).booleanValue()) {
                cacheState = true;
            }
        }
        catch (Exception e) {
            log.severe("error processing prep request: " + e.getMessage());
            resp.sendError(400, "bad json");
            return;
        }
        String requestUrl = jsonObj.containsKey("requesturl") ? (String)jsonObj.get("requesturl") : "";
        String confKey = (String)jsonObj.get("key");
        if (confKey == null) {
            log.info("confKey is null generating one...");
            confKey = SessionHandler.hashURI(Long.toString(System.currentTimeMillis()));
            requestUrl = requestUrl + "#/cowebkey/" + confKey;
        }
        log.info("confKey = " + confKey);
        log.info("request url = " + requestUrl);
        String sessionName = null;
        if (jsonObj.containsKey("sessionName")) {
            sessionName = (String)jsonObj.get("sessionName");
        }
        if ((handler = this.sessionManager.getSessionHandlerByConfkey(confKey, cacheState)) == null) {
            try {
                handler = this.sessionManager.createSession(confKey, cacheState);
                handler.setSessionName(sessionName);
                handler.setRequestUrl(requestUrl);
            }
            catch (CowebException ce) {
                ce.printStackTrace();
                log.severe("Exception creating SessionHandler: " + ce.getMessage());
                resp.sendError(500, "Failed to create session.");
                return;
            }
        }
        String sessionId = handler.getSessionId();
        String base = this.getServletContext().getContextPath();
        HashMap<String, Object> jsonResp = new HashMap<String, Object>();
        try {
            jsonResp.put("sessionurl", base + "/cometd");
            jsonResp.put("sessionid", sessionId);
            jsonResp.put("username", username);
            jsonResp.put("key", confKey);
            jsonResp.put("collab", new Boolean(true));
            jsonResp.put("info", new HashMap());
            String jsonStr = JSON.toString(jsonResp);
            PrintWriter writer = resp.getWriter();
            writer.print(jsonStr);
            writer.flush();
        }
        catch (Exception e) {
            log.severe("error creating prep response: " + e.getMessage());
        }
    }

    private void _handleDisconnect(HttpServletRequest req, HttpServletResponse resp) {
        log.fine("AdminServlet::_handleDisconnect ***********");
        String path = req.getPathInfo();
        log.fine("path info = " + path);
        if (path == null) {
            return;
        }
        String[] paths = path.split("/");
        if (paths == null || paths.length != 4) {
            return;
        }
        String sessionId = paths[2];
        String siteId = paths[3];
        this.sessionManager.disconnectClient(sessionId, siteId);
    }

    private Map<String, Object> getCowebConfigOptions(ServletConfig config) throws Exception {
        String configURI = config.getInitParameter("ConfigURI");
        if (configURI == null) {
            return this.getConfigOptionsFromInitParams(config);
        }
        return this.getConfigOptionsFromFile(configURI, config);
    }

    private Map<String, Object> getConfigOptionsFromInitParams(ServletConfig config) {
        String captureOutgoing;
        String captureIncoming;
        String updaterTypeMatcherClass;
        HashMap<String, Object> ops = new HashMap<String, Object>();
        String securityClass = config.getInitParameter("securityClass");
        if (securityClass != null) {
            ops.put("securityClass", securityClass);
        }
        if ((updaterTypeMatcherClass = config.getInitParameter("updaterTypeMatcherClass")) != null) {
            ops.put("updaterTypeMatcherClass", updaterTypeMatcherClass);
        }
        if ((captureIncoming = config.getInitParameter("captureIncoming")) != null) {
            ops.put("captureIncoming", captureIncoming);
        }
        if ((captureOutgoing = config.getInitParameter("captureOutgoing")) != null) {
            ops.put("captureOutgoing", captureOutgoing);
        }
        return ops;
    }

    private Map<String, Object> getConfigOptionsFromFile(String filePath, ServletConfig servletConfig) {
        InputStream in = servletConfig.getServletContext().getResourceAsStream(filePath);
        log.info("loading configuration file " + filePath);
        try {
            return (Map)JSON.parse((Reader)new InputStreamReader(in));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

