/*
 * Decompiled with CFR 0.152.
 */
package org.coweb;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.server.ServerSession;
import org.coweb.LateJoinHandler;
import org.coweb.SessionHandler;

public class ModeratorLateJoinHandler
extends LateJoinHandler {
    private static final Logger log = Logger.getLogger(ModeratorLateJoinHandler.class.getName());

    public ModeratorLateJoinHandler(SessionHandler sessionHandler, Map<String, Object> config) {
        super(sessionHandler, config);
    }

    @Override
    public boolean onClientJoin(ServerSession client, Message message) {
        log.info("ModeratorLateJoinHandler::onClientJoin *************");
        int siteId = this.getSiteForClient(client);
        if (siteId == -1) {
            siteId = this.addSiteForClient(client);
        }
        log.info("siteId = " + siteId);
        Map<Integer, String> roster = this.getRosterList(client);
        Map<String, Object> collabs = this.sessionModerator.getLateJoinState();
        Object[] data = new Object[collabs.size() + 1];
        int cnt = 0;
        for (Map.Entry<String, Object> collab : collabs.entrySet()) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("topic", "coweb.state.set." + collab.getKey());
            hm.put("value", collab.getValue());
            data[cnt++] = hm;
        }
        HashMap<String, Object> engState = new HashMap<String, Object>();
        engState.put("topic", "coweb.engine.state");
        engState.put("value", this.sessionHandler.getEngineState());
        data[cnt++] = engState;
        boolean first = false;
        if (this.updaters.isEmpty()) {
            this.addUpdater(client, false);
            first = true;
        } else {
            this.addUpdater(client, true);
        }
        client.batch((Runnable)new LateJoinHandler.BatchUpdateMessage(client, siteId, roster, data, true));
        return first;
    }

    @Override
    public void onUpdaterSendState(ServerSession client, Message message) {
    }

    @Override
    protected void removeUpdater(ServerSession client) {
        this.removeSiteForClient(client);
        this.updaters.remove(client.getId());
        this.sendRosterUnavailable(client);
    }
}

