package org.iri_research.renkan.rest;

import java.net.UnknownHostException;
import java.util.UUID;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.UriInfo;

import org.iri_research.renkan.db.MongoConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import com.sun.jersey.spi.resource.Singleton;

@Singleton
@Path("projects")
public class ProjectsResource {
	
	private Logger logger = LoggerFactory.getLogger(ProjectsResource.class); 
	
	@Context
	private UriInfo uriInfo;
	
	private DB getDb() {
		DB db = null;
		try {
			db = MongoConnectionManager.getInstance().getDb();
		} catch (UnknownHostException e) {
			throw new WebApplicationException(e, Status.INTERNAL_SERVER_ERROR);
		} catch (MongoException e) {
			throw new WebApplicationException(e, Status.INTERNAL_SERVER_ERROR);
		}
		return db;
	}
	
	private DBCollection getCollection() {		
		DB db = this.getDb();
		return db.getCollection("projects");
	}

	@GET
	@Path("{id : [a-zA-Z\\-0-9]+}")
	@Produces(MediaType.APPLICATION_JSON + ";charset=utf-8")
	public String getProject(@PathParam("id") String projectId) {
		
		this.logger.debug("GetProject : id " + projectId);
		
		DBCollection projectCollection = this.getCollection();
		DBObject project = projectCollection.findOne(projectId);
		
		if (null == project) {
			throw new WebApplicationException(Status.NOT_FOUND);
		}
		
		return project.toString();
				
		/*return "{" +
    "\"title\": \"Test Graph\"," +
    "\"creation_date\": \"2012-07-25T11:00:00.0Z\"," +
    "\"users\": [" +
    "{" +
    "\"id\": \"u-cybunk\"," +
    "\"title\": \"Samuel\"," +
    "\"uri\": \"http://twitter.com/cybunk\"," +
    "\"color\": \"#e00000\"" +
    "}," +
    "{" +
    "\"id\": \"u-raphv\"," +
    "\"title\": \"Raphael\"," +
    "\"uri\": \"http://twitter.com/raphv\"," +
    "\"color\": \"#00a000\"" +
    "}" +
    "]," +
    "\"nodes\": [" +
    "{" +
    "\"id\": \"n-001\"," +
    "\"title\": \"連環 (Renkan)\"," +
    "\"uri\": \"http://ja.wikipedia.org/wiki/%E7%99%BE%E5%AD%A6%E9%80%A3%E7%92%B0\"," +
    "\"created_by\": \"u-cybunk\"," +
    "\"position\": {" +
        "\"x\": 0," +
        "\"y\": 0" +
    "}" +
    "}," +
    "{" +
    "\"id\": \"n-002\"," +
    "\"title\": \"Savoir\"," +
    "\"uri\": \"http://fr.wikipedia.org/wiki/Savoir\"," +
    "\"created_by\": \"u-raphv\"," +
    "\"position\": {" +
        "\"x\": 200," +
        "\"y\": 50" +
    "}" +
    "}," +
    "{" +
    "\"id\": \"n-003\"," +
    "\"title\": \"Connaissance\","+
    "\"uri\": \"http://fr.wikipedia.org/wiki/Connaissance\","+
    "\"created_by\": \"u-raphv\","+
    "\"position\": {"+
        "\"x\": 300,"+
            "\"y\": -50"+
        "}"+
    "},"+
    "{"+
        "\"id\": \"n-004\","+
        "\"title\": \"graphe\","+
        "\"uri\": \"http://fr.wikipedia.org/wiki/Th%C3%A9orie_des_graphes\","+
        "\"created_by\": \"u-cybunk\","+
        "\"position\": {"+
            "\"x\": -200,"+
            "\"y\": 0"+
        "}"+
    "},"+
    "{"+
        "\"id\": \"n-005\","+
        "\"title\": \"nœud\","+
        "\"uri\": \"http://fr.wikipedia.org/wiki/Th%C3%A9orie_des_graphes\","+
        "\"created_by\": \"u-cybunk\","+
        "\"position\": {"+
            "\"x\": -350,"+
            "\"y\": 100"+
        "}"+
    "},"+
    "{"+
        "\"id\": \"n-006\","+
        "\"title\": \"lien\","+
        "\"uri\": \"http://fr.wikipedia.org/wiki/Th%C3%A9orie_des_graphes\","+
        "\"created_by\": \"u-cybunk\","+
        "\"position\": {"+
            "\"x\": -300,"+
            "\"y\": -100"+
        "}"+
    "}"+
    "],"+
    "\"edges\": ["+
    "{"+
        "\"id\": \"e-001\","+
        "\"from\": \"n-001\","+
        "\"to\": \"n-002\","+
        "\"created_by\": \"u-raphv\""+
    "},"+
    "{"+
        "\"id\": \"e-002\","+
        "\"from\": \"n-002\","+
        "\"to\": \"n-003\","+
        "\"created_by\": \"u-raphv\""+
    "},"+
    "{"+
        "\"id\": \"e-003\","+
        "\"from\": \"n-001\","+
        "\"to\": \"n-004\","+
        "\"created_by\": \"u-cybunk\""+
    "},"+
    "{"+
        "\"id\": \"e-004\","+
        "\"from\": \"n-004\","+
        "\"to\": \"n-005\","+
        "\"created_by\": \"u-cybunk\""+
    "},"+
    "{"+
        "\"id\": \"e-005\","+
        "\"from\": \"n-004\","+
        "\"to\": \"n-006\","+
        "\"created_by\": \"u-cybunk\""+
    "}"+
    "]"+
    "}";*/
	}

	/**
	 * test: curl -i -X PUT -H 'Content-Type: application/json' -d @test-data.json  http://localhost:8080/renkan/rest/projects/12eff140-e65c-11e1-aff1-0800200c9a66
	 * @param projectId
	 * @param projectContent
	 */
	@PUT
	@Path("{id : [a-zA-Z\\-0-9]+}")
	@Consumes(MediaType.APPLICATION_JSON)
	public Response putProject(@PathParam("id") String projectId, String projectContent) {
		
		return this.createOrUpdateProject(projectId, projectContent);		
	}

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	public Response postProject(String projectContent) {
		
		return this.createOrUpdateProject(null, projectContent);
		
	}
	
	private Response createOrUpdateProject(String projectId, String projectContent) {
		
		if(null == projectContent || projectContent.isEmpty()) {
			throw new WebApplicationException(Response.status(Status.BAD_REQUEST).entity("No content").build());
		}
		
		DBCollection projectCollection = this.getCollection(); 
		
		DBObject obj = (DBObject)JSON.parse(projectContent);
		if(obj == null) {
			throw new WebApplicationException(Response.status(Status.BAD_REQUEST).entity("Parse error").build());
		}
		
		String newProjectId = projectId;
		
		if(newProjectId == null) {
			newProjectId = UUID.randomUUID().toString();
		}
		
		obj.put("_id", newProjectId);
		
		WriteResult res = projectCollection.update(new BasicDBObject("_id", newProjectId), obj, true, false);
		
		if(res.getLastError().ok()) {
			if(projectId == null) {
				return Response.created(this.uriInfo.getAbsolutePathBuilder().segment(newProjectId).build()).build();
			}
			else {
				return Response.noContent().build();
			}
		}
		else {
			throw new WebApplicationException(Response.status(Status.BAD_REQUEST).entity(res.getError()).build());
		}
		
	}
	
}
