package org.iri_research.renkan.models;

import java.io.Serializable;

import org.iri_research.renkan.RenkanRuntimeException;


public abstract class AbstractRenkanModel<ID extends Serializable> implements IRenkanModel<ID> {
	
	public AbstractRenkanModel(ID id, String title, String description, String uri, String color) {
		super();
		this.id = id;
		this.title = title;
		this.description = description;
		this.uri = uri;
		this.color = color;
	}
	
	protected AbstractRenkanModel() {		
	}

	protected ID id;
	protected String title;
	protected String description;
	protected String uri;
	protected String color;
	
	@Override
	public String getTitle() {
		return this.title;
	}

	@Override
	public String getDescription() {
		return this.description;
	}

	@Override
	public String getUri() {
		return this.uri;
	}
	
	@Override
	public String getColor() {
		return this.color;
	}
	
	@Override
	public ID getId() {
		return this.id;
	}
	
	@Override
	public void setId(ID id) throws RenkanRuntimeException {
		if(this.id != null) {
			throw new RenkanRuntimeException("Current id is not null, can not change object id");
		}
		this.id = id;
	}
		
}
