(function() {
	
	var root = this;
		
	var Backbone = root.Backbone;
	
	var Models = root.Rkns.Models = {};
	
	
	Models.getUID = function(obj) {
		var guid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
		    var r = Math.random()*16|0, v = c == 'x' ? r : (r&0x3|0x8);
		    return v.toString(16);
		});
		return obj.type + "-" + guid; 
	};
	
	
	var RenkanModel = Backbone.RelationalModel.extend({
		idAttribute : "_id",
		constructor: function(options) {
			
			if (typeof options !== "undefined") {
	            options._id = options.id || Models.getUID(this);
	            options.title = options.title || "(untitled " + this.type + ")";
	            options.description = options.description || "";
	            options.uri = options.uri || "";
	            
	            if(typeof this.prepare === "function") {
	            	options = this.prepare(options);
	            }
			}
			Backbone.RelationalModel.prototype.constructor.call(this, options);
		},
		validate: function() {
			if(!this.type) {
				return "object has no type";
			}
		},
		addReference : function(_options, _propName, _list, _id, _default) {
		    var _element = _list.get(_id);
		    if (typeof _element === "undefined" && typeof _default !== "undefined") {
		        _options[_propName ] = _default;
		    }
		    else {
		    	_options[_propName ] = _element;
		    }
		}
	});
	
		
	// USER
	var User = Models.User = root.Rkns.Models.User = RenkanModel.extend({
		type: "user",
		prepare: function(options) {
			options.color = options.color || "#666666";
			return options;
		}	
	
	});
	
	// NODE
	var Node = Models.Node = root.Rkns.Models.Node = RenkanModel.extend({
		type: "node",
		relations: [{
			type: Backbone.HasOne,
			key: "created_by",
			relatedModel: User
		}],
		prepare: function(options) {
			project = options.project;
			this.addReference(options, "created_by", project.get("users"), options.created_by, project.current_user);
			options.description = options.description || "";			
			return options;
		}
	
	});
	
	// EDGE
	var Edge = Models.Edge = root.Rkns.Models.Edge = RenkanModel.extend({
		type: "edge",
		relations: [
		  {
			type: Backbone.HasOne,
			key: "created_by",
			relatedModel: User
		  },
		  {
		    type: Backbone.HasOne,
			key: "from",
			relatedModel: Node
		  },
		  {
		    type: Backbone.HasOne,
			key: "to",
			relatedModel: Node
		  },
		],
		prepare: function(options) {
			project = options.project;
			this.addReference(options, "created_by", options.created_by, project.get("users"), project.current_user);
			this.addReference(options, "from", options.from, project.get("nodes"));
			this.addReference(options, "to", options.to, project.get("nodes"));
			return options;
		}
	});
		
	// PROJECT
	var Project = Models.Project = root.Rkns.Models.Project = RenkanModel.extend({
		type: "project",
		relations: [
		  {
		    type: Backbone.HasMany,
		    key: "users",
		    relatedModel: User,
		    reverseRelation: {
	            key: 'project',
	            includeInJSON: '_id'
	        },
		  },
		  {
		    type: Backbone.HasMany,
		    key: "nodes",
		    relatedModel: Node,
		    reverseRelation: {
	            key: 'project',
	            includeInJSON: '_id'
	        },
		  },
		  {
		    type: Backbone.HasMany,
		    key: "edges",
		    relatedModel: Edge,
		    reverseRelation: {
	            key: 'project',
	            includeInJSON: '_id'
	        },
		  }
		],
		addNode: function(_props) {
			_props.project = this;
			this.get("nodes").push(_props);
		}
	});

	
}).call(this);

