package org.iri_research.renkan.forms;

import java.util.Date;

import org.iri_research.renkan.Constants;
import org.iri_research.renkan.models.Space;
import org.iri_research.renkan.repositories.IRenkanRepository;
import org.iri_research.renkan.repositories.SpacesRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceForm extends RenkanForm<String, Space> {

    @Autowired
    private SpacesRepository spacesRepository;

    public SpaceForm() {
        super();
    }

    public SpaceForm(Space model) {
        super(model);
        this.binConfig = model.getBinConfig();
        this.image = model.getImage();
    }

    private String binConfig;
    private String image;

    public String getBinConfig() {
        return binConfig;
    }

    public void setBinConfig(String binConfig) {
        this.binConfig = binConfig;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Override
    protected void saveToModel() {
        if (this.getId() == null || this.getId().length() == 0) {
            this.model.setId(Constants.UUID_GENERATOR.generate().toString());
            this.model.setCreated(new Date());
        }
        this.model.setBinConfig(binConfig);
        this.model.setImage(image);
    }

    @Override
    protected IRenkanRepository<Space, String> getRepository() {
        return this.spacesRepository;
    }

    @Override
    protected Space getModelInstance() {
        return new Space();
    }

    @Autowired
    public void setSpacesRepository(SpacesRepository spacesRepository) {
        this.spacesRepository = spacesRepository;
    }

}
