package org.iri_research.renkan.repositories;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections4.IteratorUtils;
import org.iri_research.renkan.models.Group;
import org.iri_research.renkan.models.User;
import org.springframework.beans.factory.annotation.Autowired;

public class GroupsRepositoryImpl implements GroupsRepositoryCustom {

    @Autowired
    private UsersRepository usersRepository;
    
    @Autowired
    private GroupsRepository groupsRepository;
    
    @Override
    // TODO: implement a transaction mecanism...
    public void setUsersList(Group group, List<String> userIds) {
        
        // takes previous user list
        List<String> oldUsers = new ArrayList<>(group.getUsers());
        
        // calculate difference between two list
        List<String> userIdDel =  new ArrayList<>(oldUsers);
        userIdDel.removeAll(userIds);
        
        List<String> userIdAdd = new ArrayList<>(userIds);
        userIdAdd.removeAll(oldUsers);
        
        List<User> userAdd = IteratorUtils.toList(this.usersRepository.findAll(userIdAdd).iterator());
        for (User user : userAdd) {
            user.addGroup(group.getId());
        }
        this.usersRepository.save(userAdd);
        List<User> userDel = IteratorUtils.toList(this.usersRepository.findAll(userIdDel).iterator());
        for (User user : userDel) {
            user.removeGroup(group.getId());
        }
        this.usersRepository.save(userDel);
        
        group.getUsers().clear();
        group.getUsers().addAll(userIds);
        
        this.groupsRepository.save(group);
    }

}
