package org.iri_research.renkan.repositories;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections4.IteratorUtils;
import org.iri_research.renkan.models.Group;
import org.iri_research.renkan.models.User;
import org.springframework.beans.factory.annotation.Autowired;

public class UsersRepositoryImpl implements UsersRepositoryCustom {

    @Autowired
    private UsersRepository usersRepository;
    
    @Autowired
    private GroupsRepository groupsRepository;
    
    @Override
    // TODO: implement a transaction mecanism...
    public void setGroupsList(User user, List<String> groupIds) {
        
        // takes previous user list
        List<String> oldGroups = new ArrayList<>(user.getGroups());
        
        // calculate difference between two list
        List<String> groupIdDel =  new ArrayList<>(oldGroups);
        groupIdDel.removeAll(groupIds);
        
        List<String> groupIdAdd = new ArrayList<>(groupIds);
        groupIdAdd.removeAll(oldGroups);
        
        List<Group> groupAdd = IteratorUtils.toList(this.groupsRepository.findAll(groupIdAdd).iterator());
        for (Group group : groupAdd) {
            group.addUser(user);
        }
        this.groupsRepository.save(groupAdd);
        List<Group> groupDel = IteratorUtils.toList(this.groupsRepository.findAll(groupIdDel).iterator());
        for (Group group : groupDel) {
            group.removeUser(user);
        }
        this.groupsRepository.save(groupDel);
        
        user.getGroups().clear();
        user.getGroups().addAll(groupIds);
        
        this.usersRepository.save(user);
    }

}
