'''
Created on Jul 17, 2014

@author: tc
'''
from django.conf import settings
from django.db import models
from easy_thumbnails.fields import ThumbnailerImageField

auth_user_model = getattr(settings, 'AUTH_USER_MODEL', 'auth.User')

class Renkan(models.Model):
    
    owner = models.ForeignKey(auth_user_model, blank=True, null=True)
    rk_id = models.CharField(max_length=1024, unique=True, blank=False, null=False) # typically UUID
    content = models.TextField(blank=True, null=True)
    title = models.CharField(max_length=1024, null=True)
    image = ThumbnailerImageField(upload_to="thumbnails/renkan/", default=settings.DEFAULT_RENKAN_ICON)
    creation_date = models.DateTimeField(auto_now_add=True)
    modification_date = models.DateTimeField(auto_now=True)
    
    class Meta:
        app_label = 'renkanmanager'
