package org.iri_research.renkan.models;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="projects")
public class Project extends AbstractRenkanModel<String> {
	
	@SuppressWarnings("unused")
	private static Logger logger = LoggerFactory.getLogger(Project.class); 
			
	private int revCounter = 1;
		
	// Nodes
	@DBRef
	private List<Node> nodes = new ArrayList<Node>();
	
	// edges
	@DBRef
	private List<Edge> edges = new ArrayList<Edge>();

	// Users
	@DBRef
	private List<User> users = new ArrayList<User>();

	
	
	public Project(String id, String title, String description, String uri,
			int revCounter) {
		super(id,title, description, uri);
		this.revCounter = revCounter;
	}

	public Project(String id, String title, String description, String uri) {
		this(id,title, description, uri, 1);
	}
	
	@SuppressWarnings("unused")
	private Project() {		
	}
	
	public int getRevCounter() {
		return this.revCounter;
	}
	
	public List<Node> getNodes() {
		return this.nodes;
	}

	public List<Edge> getEdges() {
		return this.edges;
	}
	
	public List<User> getUsers() {
		return this.users;
	}

}
