from django.shortcuts import render_to_response
from django.template import RequestContext
from django.views.generic import View


class RemieIframeTesterView(View):
    """
        A view for testing purposes that allows user to select which iframe view to test
    """
    template_name = "remie/iframe_tester.html"
    
    def get(self, request):
        return render_to_response(self.template_name, context_instance=RequestContext(request))


class RemieSegmentsSingleView(View):
    """
        The view with the segment-scenario for single user
    """
    template_name = "remie/iframe_segments_single.html"
    
    def get(self, request):
        project_id = request.GET.get("project_id", "") # id of the project we're working on
        current_user = request.user
        render_data = {
            "project_id": project_id,
            "current_user": current_user.username,
        }
        return render_to_response(self.template_name, render_data, context_instance=RequestContext(request))
    

class RemieSegmentsGroupView(View):
    """
        The view with the segment-scenario for group
    """
    template_name = "remie/iframe_segments_group.html"
    
    def get(self, request):
        project_id = request.GET.get("project_id", "") # id of the project we're working on
        current_user = request.user
        render_data = {
            "project_id": project_id,
            "current_user": current_user.username,
        }
        return render_to_response(self.template_name, render_data, context_instance=RequestContext(request))


class RemieSegmentsPreviewView(View):
    """
        The view with the segment-scenario for previews
    """
    template_name = "remie/iframe_segments_preview.html"
    
    def get(self, request):
        project_id = request.GET.get("project_id", "") # id of the project we're working on
        current_user = request.user
        render_data = {
            "project_id": project_id,
            "current_user": current_user.username,
        }
        return render_to_response(self.template_name, render_data, context_instance=RequestContext(request))
    

class RemieMarkersView(View):
    """
        The view with the markers-scenario 
    """
    template_name = "remie/iframe_markers.html"
    
    def get(self, request):
        project_id = request.GET.get("project_id", "") # id of the project we're working on
        current_user = request.user
        render_data = {
            "project_id": project_id,
            "current_user": current_user.username,
        }
        return render_to_response(self.template_name, render_data, context_instance=RequestContext(request))


class RemieMarkersPreviewView(View):
    """
        The view with the markers-scenario 
    """
    template_name = "remie/iframe_markers_preview.html"
    
    def get(self, request):
        project_id = request.GET.get("project_id", "") # id of the project we're working on
        current_user = request.user
        render_data = {
            "project_id": project_id,
            "current_user": current_user.username,
        }
        return render_to_response(self.template_name, render_data, context_instance=RequestContext(request))


class RemieTeacherView(View):
    """
        The view with the teacher-scenario 
    """
    template_name = "remie/iframe_teacher.html"
    
    def get(self, request):
        project_id = request.GET.get("project_id", "") # id of the project we're working on
        current_user = request.user
        render_data = {
            "project_id": project_id,
            "current_user": current_user.username,
        }
        return render_to_response(self.template_name, render_data, context_instance=RequestContext(request))