from django.shortcuts import render_to_response
from django.template import RequestContext
from django.views.generic import View


class RemieIframeTesterView(View):
    """
        A view for testing purposes that allows user to select which iframe view to test
    """
    template_name = "remie/iframe_tester.html"
    
    def get(self, request):
        return render_to_response(self.template_name, context_instance=RequestContext(request))

class RemieSegmentsView(View):
    """
        The view with the segment-scenario (will be standardized to be able to generate every view at some point)
    """
    template_name = "remie/iframe.html"
    
    def get(self, request):
        project_id = request.GET.get("project_id", "") # id of the project we're working on
        current_user = request.GET.get("current_user", "") # current username
        group_mode = {'true': True, 'false': False, "0": False, "1": True}.get(request.GET.get("group_mode", "").lower()) # if group_mode, annotations from everybody will be displayed
        render_data = {
            "project_id": project_id,
            "current_user": current_user,
            "group_mode": group_mode
        }
        return render_to_response(self.template_name, render_data, context_instance=RequestContext(request))