"""remieplt URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/dev/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Add an import:  from blog import urls as blog_urls
    2. Add a URL to urlpatterns:  url(r'^blog/', include(blog_urls))
"""
from ldt.auth.views import login as pf_login
from ldt.text import VERSION_STR

from django.conf import settings
from django.conf.urls import include, url
from django.conf.urls.static import static
from django.core.urlresolvers import reverse_lazy
from django.contrib import admin
from django.contrib.staticfiles.urls import staticfiles_urlpatterns
from django.views.generic import RedirectView
from django.contrib.auth.decorators import login_required


from remie.views import RemieSegmentsSingleView, RemieSegmentsGroupView, RemieMarkersView, RemieTeacherView, RemieSegmentsPreviewView, RemieMarkersPreviewView, RemieMarkersTeacherView, RemieIframeTesterView

js_info_dict = {
    'packages': ('django.contrib.admin',),
}

urlpatterns = [
    url(r'^admin/', include(admin.site.urls)),
    url(r'^i18n/', include('django.conf.urls.i18n')),

    url(r'^ldt/', include('ldt.ldt_utils.urls')),
    url(r'^user/', include('ldt.user.urls')),
    url(r'^api/', include('ldt.api.urls')),
    url(r'^api/' + VERSION_STR + '/text/', include('ldt.text.urls')),

    url(r'^auth_accounts/', include('registration.backends.simple.urls')),

    url(r'^accounts/', include('social.apps.django_app.urls', namespace='social')),
    url(r'^accounts/login/$',pf_login,{'template_name': 'registration/login.html'},name='auth_login'),
    url(r'^accounts/cas/login/$', 'django_cas_ng.views.login', name='cas_login'),
    url(r'^accounts/cas/logout/$', 'django_cas_ng.views.logout', name='cas_logout'),
    url(r'^oauth/', include('oauth_provider.urls')),

    url(r'^remie/iframetester$', RemieIframeTesterView.as_view(), name="remie_iframe_tester"),

    url(r'^remie/workunit/segments_group$', login_required(RemieSegmentsGroupView.as_view(), login_url=reverse_lazy('cas_login')), name="remie_segments_group"),
    url(r'^remie/workunit/segments_single$', login_required(RemieSegmentsSingleView.as_view(), login_url=reverse_lazy('cas_login')), name="remie_segments_single"),
    url(r'^remie/workunit/segments_preview$', login_required(RemieSegmentsPreviewView.as_view(), login_url=reverse_lazy('cas_login')), name="remie_segments_preview"),
    url(r'^remie/workunit/markers_teacher$', login_required(RemieMarkersTeacherView.as_view(), login_url=reverse_lazy('cas_login')), name="remie_markers_teacher"),
    url(r'^remie/workunit/markers$', login_required(RemieMarkersView.as_view(), login_url=reverse_lazy('cas_login')), name="remie_markers"),
    url(r'^remie/workunit/markers_preview$', login_required(RemieMarkersPreviewView.as_view(), login_url=reverse_lazy('cas_login')), name="remie_markers_preview"),
    url(r'^remie/workunit/teacher$', login_required(RemieTeacherView.as_view(), login_url=reverse_lazy('cas_login')), name="remie_teacher"),

    url(r'^/?$', RedirectView.as_view(url='ldt'), name="remie_iframe_container"),

    url(r'^jsi18n/$', 'django.views.i18n.javascript_catalog', js_info_dict),

    url(r'^short/(?P<base62_id>[A-Za-z0-9]+)$', 'shortener.views.follow', name="shortener_follow")

]

urlpatterns += staticfiles_urlpatterns()
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
