<?php namespace TestCAS\Providers;

use Illuminate\Support\ServiceProvider;
use Cas;
use phpCAS;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Cas::connection();
        phpCAS::setExtraCurlOption(CURLOPT_SSL_VERIFYHOST, 0);
        phpCAS::setFixedCallbackURL("https://homestead.app/pgtcallback");
        phpCAS::setPGTStorageFile(env("TICKET_STORAGE_PATH"));
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {

    }
}
