import platform
import os
import sys

from lib_create_env import lib_generate_install_methods

system_str = platform.system()

extra_env = None
if system_str == 'Darwin':
    extra_env = {'STATIC_DEPS': 'true', 'LIBXML2_VERSION': '2.9.2', 'LIBXSLT_VERSION': '1.1.28', 'LIBICONV_VERSION': '1.14'}
    if os.path.exists('/usr/local/opt/xz'):
        if not os.path.exists('/usr/local/opt/libxml2'):
            sys.exit("You have installed xz with Homebrew but do not have libxml2 installed with Homebrew. Install libxml2 with Homebrew and try again.")
        extra_env = {'LDFLAGS': '-L/usr/local/opt/libxml2/lib', 'CPPFLAGS': '-I/usr/local/opt/libxml2/include'}



INSTALLS = [  # (key,method, option_str, dict_extra_env)
    {
        'requirement':'requirements.txt',
        'install': {
            'option_str': None,
            'dict_extra_env': extra_env
        }
    },
#    'LXML',
#    'SIMPLEJSON',
#    'PSYCOPG2',
    #'MYSQL',
#    'PIL',
#    'DJANGO',
#    'DJANGO-EXTENSIONS',
#    'DJANGO-REGISTRATION',
#    'DJANGO-TAGGIT',
#    'DJANGO-TAGGIT-TEMPLATETAGS',
#    'HTTPLIB2',
#    'OAUTH2',
#    'OAUTHLIB',
#    'SETUPTOOLS_HG',
#    'DJANGO-OAUTH-PLUS',
#    'OPENID',
#    'SOCIAL_AUTH',
#    'DJANGO_GUARDIAN',
#    'SORL_THUMBNAIL',
#    'HAYSTACK',
#    'URLLIB3',
#    'REQUESTS',
#    'ELASTICSEARCH',
#    'PYELASTICSEARCH',
#    'WHOOSH',
#    'MIMEPARSE',
#    'SIX',
#    'PYTHON-DATEUTIL',
#    'PYYAML',
#    'PYTHON-DIGEST',
#    'DEFUSEDXML',
#    'DJANGO-TASTYPIE',
#    'DJANGO-CORS-HEADERS',
#    'DJANGO-CHUNCKED-UPLOADS',
#    'PYJWT',
#    'DJANGO-TEMPLATETAG-SUGAR',
#    'PYTHON-MIMEPARSE',
#    'REQUESTS-OAUTHLIB',
#    'SOUTH,
#    'DJANGO_CAS_NG',
]

OPTIONS_TO_ADD = {'type_install': 'local', 'unzip_setuptools': True}

def generate_install_methods(path_locations, src_base, run_base, Logger, call_subprocess):
    return lib_generate_install_methods(path_locations, src_base, run_base, Logger, call_subprocess, INSTALLS, OPTIONS_TO_ADD)
